/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class IntRange
implements Cloneable {
    public static final String SUBRANGE_SEPARATOR = ",";
    public static final String INTERVAL_SEPARATOR = "-";
    private int[][] intervals = null;
    private int intervalIndex = 0;
    private int element = -1;
    private int nextElement = -1;
    private int count = 0;
    private int maxCount = Integer.MAX_VALUE;
    private static final Comparator<int[]> intervalComparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            return o1[0] - o2[0];
        }
    };

    private static void testConsistency(ArrayList<int[]> intervalList) {
        for (int[] is : intervalList) {
            if (is.length != 2) {
                throw new IllegalArgumentException("Not an interval: " + StringUtil.arrayToString(is, INTERVAL_SEPARATOR));
            }
            if (is[0] < 0) {
                throw new IllegalArgumentException("Negative value: " + is[0] + " found in IntRange.");
            }
            if (is[0] <= is[1]) continue;
            throw new IllegalArgumentException("Illegal range format (start > end): " + is[0] + " - " + is[1]);
        }
    }

    public IntRange(ArrayList<int[]> intervalList) {
        IntRange.testConsistency(intervalList);
        this.intervals = IntRange.unionOfIntervalList(intervalList);
    }

    public IntRange(int[][] intervals) {
        int[][] c = IntRange.deepCopyIntInt(intervals);
        ArrayList<int[]> tmp = new ArrayList<int[]>(intervals.length);
        tmp.addAll(Arrays.asList(c));
        IntRange.testConsistency(tmp);
        this.intervals = IntRange.unionOfIntervalList(tmp);
    }

    public IntRange(int min, int max) {
        this(new int[][]{{min, max}});
    }

    public IntRange(String range) throws IllegalArgumentException {
        this.intervals = IntRange.parseRange(range, true);
    }

    public static boolean isValidRangeString(String range) {
        try {
            return IntRange.parseRange(range, false) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void reset() {
        this.intervalIndex = 0;
        this.element = -1;
        this.nextElement = -1;
        this.count = 0;
    }

    private static int[][] parseRange(String range, boolean fuseOverlaps) throws IllegalArgumentException {
        ArrayList<int[]> intervalList = new ArrayList<int[]>();
        StringTokenizer st = new StringTokenizer(range, SUBRANGE_SEPARATOR);
        while (st.hasMoreTokens()) {
            String subrange = st.nextToken().trim();
            int start = -1;
            int end = -1;
            int k = subrange.indexOf(INTERVAL_SEPARATOR);
            try {
                if (k == -1) {
                    start = end = Integer.decode(subrange).intValue();
                } else {
                    String s1 = subrange.substring(0, k).trim();
                    start = s1.length() == 0 ? 1 : Integer.decode(s1);
                    String s2 = subrange.substring(k + 1).trim();
                    end = s2.length() == 0 ? Integer.MAX_VALUE : Integer.decode(s2);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal range format (number format error): " + range, e);
            }
            intervalList.add(new int[]{start, end});
        }
        IntRange.testConsistency(intervalList);
        if (!fuseOverlaps || intervalList.size() < 2) {
            return intervalList.size() > 0 ? (int[][])intervalList.toArray((T[])new int[intervalList.size()][2]) : (int[][])null;
        }
        return IntRange.unionOfIntervalList(intervalList);
    }

    private static int[][] unionOfIntervalList(List<int[]> intervalList) {
        Collections.sort(intervalList, intervalComparator);
        int[][] intervals = new int[intervalList.size()][2];
        intervalList.toArray((T[])intervals);
        intervalList.clear();
        int j = intervals.length;
        int i = 0;
        while (i < intervals.length) {
            intervalList.add(intervals[i]);
            for (j = i + 1; j < intervals.length; ++j) {
                int maxOfCurrent;
                int minOfNext = intervals[j][0];
                int n = maxOfCurrent = intervals[i][1] == Integer.MAX_VALUE ? Integer.MAX_VALUE : intervals[i][1] + 1;
                if (minOfNext > maxOfCurrent) break;
                intervals[i][1] = Math.max(intervals[i][1], intervals[j][1]);
            }
            i = j;
        }
        if (intervalList.size() < intervals.length) {
            intervals = new int[intervalList.size()][2];
            intervalList.toArray((T[])intervals);
        }
        int[][] arr$ = intervals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] is;
            for (int i2 : is = arr$[i$]) {
                if (i2 >= 0) continue;
                throw new UnsupportedOperationException("[BUG] unionOfIntervalList resulted in negative integer");
            }
        }
        return intervals;
    }

    public int size() {
        int s = 0;
        for (int[] interval : this.intervals) {
            s += IntRange.add(interval[1] - interval[0], 1);
        }
        return Math.min(s, this.maxCount);
    }

    public int[] toArray() {
        this.reset();
        int[] a = new int[this.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.next();
        }
        return a;
    }

    public boolean hasNext() {
        if (this.nextElement != -1) {
            return true;
        }
        this.next0();
        this.nextElement = this.element;
        return this.nextElement != -1;
    }

    public int next() throws NoSuchElementException {
        if (this.nextElement == -1) {
            this.next0();
        }
        this.nextElement = -1;
        if (this.element == -1) {
            throw new NoSuchElementException();
        }
        ++this.count;
        return this.element;
    }

    private void next0() {
        if (this.intervalIndex < this.intervals.length && this.count < this.maxCount) {
            int[] interval = this.intervals[this.intervalIndex];
            if (this.element == -1) {
                this.element = interval[0];
            } else {
                ++this.element;
                if (this.element > interval[1]) {
                    ++this.intervalIndex;
                    this.element = -1;
                    this.next0();
                }
            }
        } else {
            this.element = -1;
        }
    }

    public boolean contains(int num) {
        for (int[] interval : this.intervals) {
            if (interval[0] > num || interval[1] < num) continue;
            return true;
        }
        return false;
    }

    public int[][] getIntervals() {
        return this.intervals;
    }

    public void unionWith(IntRange range) {
        ArrayList<int[]> intervalList = new ArrayList<int[]>();
        for (int[] interv : this.intervals) {
            intervalList.add(interv);
        }
        for (int[] interv : range.intervals) {
            intervalList.add((int[])interv.clone());
        }
        this.intervals = IntRange.unionOfIntervalList(intervalList);
    }

    public static int add(int a, int b) {
        if (a == Integer.MAX_VALUE || b == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return a + b;
    }

    public void sumWith(IntRange range) {
        int[][] a = this.intervals;
        int[][] b = range.intervals;
        ArrayList<int[]> intervalList = new ArrayList<int[]>();
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                int[] result = new int[]{IntRange.add(a[j][0], b[i][0]), IntRange.add(a[j][1], b[i][1])};
                intervalList.add(result);
            }
        }
        this.intervals = IntRange.unionOfIntervalList(intervalList);
    }

    public void simplifyThisToASingleRange() {
        int min = this.min();
        int max = this.max();
        this.intervals = new int[][]{{min, max}};
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.intervals.length; ++i) {
            buffer.append(this.intervals[i][0]);
            if (this.intervals[i][0] != this.intervals[i][1]) {
                buffer.append(INTERVAL_SEPARATOR);
                if (this.intervals[i][1] != Integer.MAX_VALUE) {
                    buffer.append(this.intervals[i][1]);
                }
            }
            if (i >= this.intervals.length - 1) continue;
            buffer.append(SUBRANGE_SEPARATOR);
        }
        return buffer.toString();
    }

    public void intersectionWith(IntRange range) {
        int[] subRangeIndex = new int[]{0, 0};
        ArrayList<int[]> mergedIntervals = new ArrayList<int[]>();
        while (subRangeIndex[0] < this.intervals.length && subRangeIndex[1] < range.intervals.length) {
            this.intersectSubranges(range, subRangeIndex, mergedIntervals);
        }
        this.intervals = (int[][])mergedIntervals.toArray((T[])new int[mergedIntervals.size()][2]);
    }

    private void intersectSubranges(IntRange range, int[] subRangeIndex, List<int[]> mergedIntervals) {
        int[] interval0 = this.intervals[subRangeIndex[0]];
        int[] interval1 = range.intervals[subRangeIndex[1]];
        if (interval0[0] > interval1[1]) {
            subRangeIndex[1] = subRangeIndex[1] + 1;
            return;
        }
        if (interval1[0] > interval0[1]) {
            subRangeIndex[0] = subRangeIndex[0] + 1;
            return;
        }
        int[] intervalResult = new int[]{Math.max(interval0[0], interval1[0]), Math.min(interval0[1], interval1[1])};
        mergedIntervals.add(intervalResult);
        if (interval0[1] < interval1[1]) {
            subRangeIndex[0] = subRangeIndex[0] + 1;
            return;
        }
        if (interval1[1] < interval0[1]) {
            subRangeIndex[1] = subRangeIndex[1] + 1;
            return;
        }
        subRangeIndex[0] = subRangeIndex[0] + 1;
        subRangeIndex[1] = subRangeIndex[1] + 1;
    }

    private static int[][] deepCopyIntInt(int[][] a) {
        int[][] ret = new int[a.length][];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            ret[i] = new int[a[i].length];
            System.arraycopy(a[i], 0, ret[i], 0, a[i].length);
        }
        return ret;
    }

    public IntRange clone() {
        return new IntRange(IntRange.deepCopyIntInt(this.intervals));
    }

    public int max() {
        return this.intervals.length == 0 ? -1 : this.intervals[this.intervals.length - 1][1];
    }

    public int min() {
        return this.intervals.length == 0 ? -1 : this.intervals[0][0];
    }
}

