/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;

public class MaskingCmdLinePasswdReader {
    public static final char[] getPassword(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        MaskingThread maskingthread = new MaskingThread(prompt);
        Thread thread = new Thread(maskingthread);
        thread.start();
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(MaskingCmdLinePasswdReader.getPassword(System.in, "Password: "));
    }

    private static class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private char echochar = (char)32;

        public MaskingThread(String prompt) {
            System.out.print(prompt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = true;
                while (this.stop) {
                    System.out.print("\b" + this.echochar);
                    try {
                        Thread.currentThread();
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

