/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.marvin.alignment.AlignRigidEasy;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.HitAlignment2D;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class MolAligner {
    private Molecule patternMol;
    private Molecule targetMol;
    private HitAlignment2D[] align2D;
    private AlignRigidEasy[] align3D;
    private int fragCount;
    private double error;
    private boolean is3D = false;
    private int sgCount;
    private int[] sgStates;
    int[] fragId;
    boolean[] fragRot;
    HashMap<MoleculeGraph, Integer> fragMin;
    MoleculeGraph[] fragParents;

    public MolAligner() {
    }

    public MolAligner(Molecule patternMolecule, Molecule targetMolecule) {
        this.setPatternMolecule(patternMolecule);
        this.setTargetMolecule(targetMolecule);
    }

    public void setPatternMolecule(Molecule mol) {
        this.patternMol = mol;
        this.initMol(mol);
    }

    public void setTargetMolecule(Molecule mol) {
        this.targetMol = mol;
        this.saveSgStates(mol);
        this.initMol(mol);
        this.fragCount = mol.getFragCount();
    }

    private void saveSgStates(Molecule mol) {
        this.sgCount = mol.getSgroupCount();
        this.sgStates = new int[this.sgCount];
        for (int sgIndex = 0; sgIndex < this.sgCount; ++sgIndex) {
            this.sgStates[sgIndex] = mol.getSgroup(sgIndex).getXState();
        }
        mol.expandSgroups();
    }

    private void loadSgStates(Molecule mol) {
        for (int sgIndex = 0; sgIndex < this.sgCount; ++sgIndex) {
            mol.getSgroup(sgIndex).setXState(this.sgStates[sgIndex]);
        }
    }

    private void initMol(Molecule mol) {
        if (mol.getDim() == 0) {
            mol.clean(2, null);
            this.is3D |= false;
        } else if (mol.getDim() > 2) {
            this.is3D = true;
        }
    }

    public double getError() {
        return this.error;
    }

    public void calculate(int[] hit) {
        this.error = 0.0;
        if (this.is3D) {
            this.calculate3D(hit);
        } else {
            this.calculate2D(hit);
        }
    }

    private void calculate2D(int[] hit) {
        this.align2D = new HitAlignment2D[this.fragCount];
        this.initFragData(hit);
        for (int fragIndex = 0; fragIndex < this.fragRot.length; ++fragIndex) {
            if (!this.fragRot[fragIndex]) continue;
            this.align2D[fragIndex] = new HitAlignment2D(this.patternMol);
            ArrayList<int[]> atomMapList = new ArrayList<int[]>();
            int fragRep = this.transformFragHit(fragIndex, hit, atomMapList);
            this.align2D[fragIndex].setMoleculeToRotate((Molecule)this.targetMol.getAtom(fragRep).getParent());
            try {
                this.align2D[fragIndex].align((int[][])atomMapList.toArray((T[])new int[0][0]));
            }
            catch (AlignmentException ex) {
                this.error = Double.MAX_VALUE;
            }
            this.error += this.align2D[fragIndex].rmsd();
        }
    }

    private void calculate3D(int[] hit) {
        this.align3D = new AlignRigidEasy[this.fragCount];
        this.initFragData(hit);
        for (int fragIndex = 0; fragIndex < this.fragRot.length; ++fragIndex) {
            if (!this.fragRot[fragIndex]) continue;
            this.align3D[fragIndex] = new AlignRigidEasy();
            this.align3D[fragIndex].setReference(this.patternMol);
            ArrayList<int[]> atomMapList = new ArrayList<int[]>();
            int fragRep = this.transformFragHit(fragIndex, hit, atomMapList);
            this.align3D[fragIndex].setRotatable((Molecule)this.targetMol.getAtom(fragRep).getParent());
            this.align3D[fragIndex].align((int[][])atomMapList.toArray((T[])new int[0][0]));
            this.error += this.align3D[fragIndex].rmsd();
        }
    }

    private int transformFragHit(int fragIndex, int[] hit, ArrayList<int[]> atomMapList) {
        int[] fragHit = new int[hit.length];
        Arrays.fill(fragHit, -1);
        int fragRep = 0;
        for (int hitIndex = 0; hitIndex < hit.length; ++hitIndex) {
            if (hit[hitIndex] < 0 || hit[hitIndex] >= this.fragId.length) continue;
            if (this.fragId[hit[hitIndex]] == fragIndex) {
                fragHit[hitIndex] = hit[hitIndex] - this.fragMin.get(this.fragParents[hit[hitIndex]]);
                fragRep = hit[hitIndex];
                continue;
            }
            fragHit[hitIndex] = -1;
        }
        for (int atomIndex = 0; atomIndex < fragHit.length; ++atomIndex) {
            if (fragHit[atomIndex] < 0) continue;
            atomMapList.add(new int[]{atomIndex, fragHit[atomIndex]});
        }
        return fragRep;
    }

    private void initFragData(int[] hit) {
        int atomCount = this.targetMol.getAtomCount();
        this.fragId = new int[atomCount];
        int fCount = -1;
        this.fragRot = new boolean[this.fragCount];
        this.fragParents = new MoleculeGraph[atomCount];
        this.fragMin = new HashMap();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            this.fragParents[atomIndex] = this.targetMol.getAtom(atomIndex).getParent();
            if (!this.fragMin.containsKey(this.fragParents[atomIndex])) {
                this.fragMin.put(this.fragParents[atomIndex], atomIndex);
            }
            this.fragId[atomIndex] = ++fCount;
        }
        for (int hitIndex = 0; hitIndex < hit.length; ++hitIndex) {
            if (hit[hitIndex] < 0 || hit[hitIndex] >= this.fragId.length) continue;
            this.fragRot[this.fragId[hit[hitIndex]]] = true;
        }
    }

    public void align() {
        if (this.is3D) {
            for (int fragIndex = 0; fragIndex < this.fragCount; ++fragIndex) {
                if (this.align3D[fragIndex] == null) continue;
                this.align3D[fragIndex].getRotatedMolecule();
            }
        } else {
            for (int fragIndex = 0; fragIndex < this.fragCount; ++fragIndex) {
                if (this.align2D[fragIndex] == null) continue;
                this.align2D[fragIndex].getRotatedMoleculeAndFlipBonds();
            }
        }
        this.loadSgStates(this.targetMol);
        CleanUtil.arrangeComponents(this.targetMol);
    }

    public void align(int[] hit) {
        this.calculate(hit);
        this.align();
    }
}

