/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.util.ArrayList;

public class MostNonOverlappingHitFinder {
    ArrayList hitList;
    private int[][] hits;
    private static final int MAX_ATOMS = 2000;
    private int selectedCount = 0;
    private int maxSelectedCount = 0;
    private boolean[] selection = null;
    private boolean[] usedAtoms = null;
    private int numberOfHits;

    public int[][][] getNonOverlappingHits(int[][] hits) {
        this.hits = hits;
        this.numberOfHits = hits.length;
        this.hitList = new ArrayList();
        this.selection = new boolean[this.numberOfHits];
        this.selectedCount = 0;
        this.maxSelectedCount = 0;
        this.usedAtoms = new boolean[2000];
        this.addNewHit();
        ArrayList<int[][]> uniqueList = new ArrayList<int[][]>();
        int size = this.hitList.size();
        block0: for (int x = 0; x < size; ++x) {
            int[][] hit = (int[][])this.hitList.get(x);
            int listSize = uniqueList.size();
            for (int y = 0; y < listSize; ++y) {
                if (this.sameHits(hit, (int[][])uniqueList.get(y))) continue block0;
            }
            uniqueList.add(hit);
        }
        size = uniqueList.size();
        int[][][] result = new int[size][][];
        for (int x = 0; x < size; ++x) {
            result[x] = (int[][])uniqueList.get(x);
        }
        return result;
    }

    private boolean sameHits(int[][] hit1, int[][] hit2) {
        int size = hit1.length;
        for (int x = 0; x < size; ++x) {
            int[] hit = hit1[x];
            boolean found = false;
            for (int y = 0; y < size; ++y) {
                if (hit != hit2[y]) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private final boolean addNewHit() {
        boolean added = false;
        block0: for (int x = 0; x < this.numberOfHits; ++x) {
            int index;
            int y;
            if (this.selection[x]) continue;
            int[] hit = this.hits[x];
            int length = this.hits[x].length;
            for (y = 0; y < length; ++y) {
                index = hit[y];
                if (index >= 0 && this.usedAtoms[index]) continue block0;
            }
            this.selection[x] = true;
            for (y = 0; y < length; ++y) {
                index = hit[y];
                if (index < 0) continue;
                this.usedAtoms[index] = true;
            }
            ++this.selectedCount;
            boolean addedMore = this.addNewHit();
            if (!addedMore && this.selectedCount >= this.maxSelectedCount) {
                if (this.selectedCount > this.maxSelectedCount) {
                    this.maxSelectedCount = this.selectedCount;
                    this.hitList.clear();
                }
                int[][] newHit = new int[this.selectedCount][];
                int p = 0;
                int sLength = this.selection.length;
                for (int y2 = 0; y2 < sLength; ++y2) {
                    if (!this.selection[y2]) continue;
                    newHit[p++] = this.hits[y2];
                }
                this.hitList.add(newHit);
                added = true;
            }
            this.selection[x] = false;
            for (int y3 = 0; y3 < length; ++y3) {
                int index2 = hit[y3];
                if (index2 < 0) continue;
                this.usedAtoms[index2] = false;
            }
            --this.selectedCount;
        }
        return added;
    }

    public static void main(String[] args) {
        int[][] hits = new int[][]{{3, 2, 4}, {1, 2, 3}, {4, 5, 6}, {5, 6, -4}};
        MostNonOverlappingHitFinder f = new MostNonOverlappingHitFinder();
        int[][][] result = f.getNonOverlappingHits(hits);
        for (int x = 0; x < result.length; ++x) {
            int[][] hitSet = result[x];
            for (int y = 0; y < hitSet.length; ++y) {
                int[] hit = hitSet[y];
                for (int z = 0; z < hit.length; ++z) {
                    System.err.print(hit[z] + "  ");
                }
                System.err.println("");
            }
            System.err.println("--------");
        }
    }
}

