/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.IntVector;
import chemaxon.util.RingMembership;
import java.util.ArrayList;
import java.util.List;

class RingMembershipRecord {
    private List<int[]> tuples = new ArrayList<int[]>();
    private List<RingMembership> ringMemberships = new ArrayList<RingMembership>();
    private List<List<IntVector>> ringParentWalks = new ArrayList<List<IntVector>>();
    private List<List<IntVector>> nonringParentWalks = new ArrayList<List<IntVector>>();

    RingMembershipRecord() {
    }

    RingMembership getRingMembership(int l1, int a, int l2) {
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        if (tupleIndex != -1) {
            return this.ringMemberships.get(tupleIndex);
        }
        return null;
    }

    private int getTupleIndex(int l1, int a, int l2) {
        for (int tupleIndex = 0; tupleIndex < this.tuples.size(); ++tupleIndex) {
            int[] tuple = this.tuples.get(tupleIndex);
            if (tuple[1] != a || l1 != tuple[0] && l1 != tuple[2] || l2 != tuple[0] && l2 != tuple[2]) continue;
            return tupleIndex;
        }
        return -1;
    }

    void setRingMembership(int l1, int a, int l2, RingMembership ringMembership) {
        if (this.getRingMembership(l1, a, l2) == ringMembership) {
            return;
        }
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        if (tupleIndex == -1) {
            this.tuples.add(new int[]{l1, a, l2});
            this.ringMemberships.add(ringMembership);
            this.ringParentWalks.add(new ArrayList());
            this.nonringParentWalks.add(new ArrayList());
            tupleIndex = this.tuples.size() - 1;
        } else {
            this.ringMemberships.set(tupleIndex, ringMembership);
            this.ringParentWalks.set(tupleIndex, new ArrayList());
            this.nonringParentWalks.set(tupleIndex, new ArrayList());
        }
        if (ringMembership != RingMembership.AMBIGUOUS && ringMembership != null) {
            List<List<IntVector>> pathListToSet = ringMembership == RingMembership.IN_RING ? this.ringParentWalks : this.nonringParentWalks;
            ArrayList<IntVector> pathsToSet = new ArrayList<IntVector>();
            pathsToSet.add(new IntVector(new int[]{a}));
            pathListToSet.set(tupleIndex, pathsToSet);
        }
    }

    public List<IntVector> getRingParentWalks(int l1, int a, int l2) {
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        if (tupleIndex == -1) {
            return new ArrayList<IntVector>();
        }
        return this.ringParentWalks.get(tupleIndex);
    }

    public List<IntVector> getNonRingParentWalks(int l1, int a, int l2) {
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        if (tupleIndex == -1) {
            return new ArrayList<IntVector>();
        }
        return this.nonringParentWalks.get(tupleIndex);
    }

    public void addParentWalks(int l1, int a, int l2, List<IntVector> parentWalks, IntVector walkTillParent, boolean ringWalk) {
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        if (tupleIndex == -1) {
            this.setRingMembership(l1, a, l2, RingMembership.AMBIGUOUS);
            tupleIndex = this.tuples.size() - 1;
        }
        List<IntVector> parentWalksToExtend = ringWalk ? this.ringParentWalks.get(tupleIndex) : this.nonringParentWalks.get(tupleIndex);
        for (IntVector parentWalk : parentWalks) {
            IntVector parentWalkToAdd = (IntVector)parentWalk.clone();
            parentWalkToAdd.addAll(walkTillParent);
            parentWalkToAdd.add(a);
            parentWalksToExtend.add(parentWalkToAdd);
        }
        this.setRingMembershipAccordingToParentWalks(l1, a, l2);
    }

    public void mergeParentWalks(int l1, int a, int l2) {
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        if (tupleIndex == -1) {
            return;
        }
        this.mergeParentWalkList(this.ringParentWalks.get(tupleIndex));
        this.mergeParentWalkList(this.nonringParentWalks.get(tupleIndex));
        List<IntVector> ringWalkList = this.ringParentWalks.get(tupleIndex);
        List<IntVector> nonringWalkList = this.nonringParentWalks.get(tupleIndex);
        for (IntVector ringWalk : ringWalkList) {
            for (int nonringInd = nonringWalkList.size() - 1; nonringInd >= 0; --nonringInd) {
                IntVector nonringWalk = nonringWalkList.get(nonringInd);
                if (!RingMembershipRecord.isSubsetOf(ringWalk, nonringWalk)) continue;
                nonringWalkList.remove(nonringInd);
            }
        }
        if (ringWalkList.size() == 0 && nonringWalkList.size() > 0) {
            nonringWalkList.clear();
            nonringWalkList.add(new IntVector(new int[]{a}));
        }
        if (nonringWalkList.size() == 0 && ringWalkList.size() > 0) {
            ringWalkList.clear();
            ringWalkList.add(new IntVector(new int[]{a}));
        }
        this.setRingMembershipAccordingToParentWalks(l1, a, l2);
    }

    private void setRingMembershipAccordingToParentWalks(int l1, int a, int l2) {
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        if (tupleIndex == -1) {
            return;
        }
        List<IntVector> ringWalkList = this.ringParentWalks.get(tupleIndex);
        List<IntVector> nonringWalkList = this.nonringParentWalks.get(tupleIndex);
        if (nonringWalkList.size() == 0 && ringWalkList.size() != 0) {
            this.ringMemberships.set(tupleIndex, RingMembership.IN_RING);
        } else if (nonringWalkList.size() != 0 && ringWalkList.size() == 0) {
            this.ringMemberships.set(tupleIndex, RingMembership.NOT_RING);
        } else {
            this.ringMemberships.set(tupleIndex, RingMembership.AMBIGUOUS);
        }
    }

    private void mergeParentWalkList(List<IntVector> list) {
        block0: for (int outerInd = list.size() - 1; outerInd >= 0; --outerInd) {
            IntVector outerWalk = list.get(outerInd);
            for (int innerInd = list.size() - 1; innerInd > outerInd; --innerInd) {
                IntVector innerWalk = list.get(innerInd);
                if (RingMembershipRecord.isSubsetOf(outerWalk, innerWalk)) {
                    list.remove(innerInd);
                    continue;
                }
                if (!RingMembershipRecord.isSubsetOf(outerWalk, innerWalk)) continue;
                list.remove(outerInd);
                continue block0;
            }
        }
    }

    static boolean isSubsetOf(IntVector subsetCandidate, IntVector secondWalk) {
        int secondLength;
        int firstLength = subsetCandidate.size();
        if (firstLength > (secondLength = secondWalk.size())) {
            return false;
        }
        for (int offSetFromTheBack = 1; offSetFromTheBack <= firstLength; ++offSetFromTheBack) {
            if (subsetCandidate.get(firstLength - offSetFromTheBack) == secondWalk.get(secondLength - offSetFromTheBack)) continue;
            return false;
        }
        return true;
    }

    public RingMembership getRingMembership(int l1, int a, int l2, int[] graphWalkToAtom) {
        int tupleIndex = this.getTupleIndex(l1, a, l2);
        IntVector inputGraphWalk = new IntVector(graphWalkToAtom);
        List<IntVector> ringWalks = this.ringParentWalks.get(tupleIndex);
        List<IntVector> nonringWalks = this.nonringParentWalks.get(tupleIndex);
        for (IntVector ringWalk : ringWalks) {
            if (!RingMembershipRecord.isSubsetOf(ringWalk, inputGraphWalk)) continue;
            return RingMembership.IN_RING;
        }
        for (IntVector nonringWalk : nonringWalks) {
            if (!RingMembershipRecord.isSubsetOf(nonringWalk, inputGraphWalk)) continue;
            return RingMembership.NOT_RING;
        }
        boolean ringWalkFound = false;
        boolean nonringWalkFound = false;
        for (IntVector ringWalk : ringWalks) {
            if (!RingMembershipRecord.isSubsetOf(inputGraphWalk, ringWalk)) continue;
            ringWalkFound = true;
        }
        for (IntVector nonringWalk : nonringWalks) {
            if (!RingMembershipRecord.isSubsetOf(inputGraphWalk, nonringWalk)) continue;
            nonringWalkFound = true;
        }
        if (ringWalkFound && nonringWalkFound) {
            return RingMembership.AMBIGUOUS;
        }
        if (ringWalkFound && !nonringWalkFound) {
            return RingMembership.IN_RING;
        }
        if (!ringWalkFound && nonringWalkFound) {
            return RingMembership.NOT_RING;
        }
        return null;
    }
}

