/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class SelectRandomMolecules {
    static boolean verbose = false;
    static String dirName;
    static Random rnd;

    public static void main(String[] args) throws IOException {
        int arg;
        if (args.length < 3) {
            System.out.println("Usage: java chemaxon.util.SelectRandomMolecules [-v] N format source-directory");
            System.exit(1);
        }
        if (args[arg = 0].equals("-v")) {
            verbose = true;
        }
        int n = ++arg;
        int n2 = Integer.parseInt(args[n]);
        int n3 = ++arg;
        String format2 = args[n3];
        int n4 = ++arg;
        ++arg;
        dirName = args[n4];
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(SelectRandomMolecules.findFiles(dirName)));
        int molsPerFile = n2 / files.size() / 2;
        if (molsPerFile < 1) {
            molsPerFile = 1;
        }
        ArrayList<Molecule> mols = new ArrayList<Molecule>();
        block0: while (n2 > 0) {
            mols.clear();
            SelectRandomMolecules.select(files, mols, molsPerFile);
            for (Molecule m : mols) {
                String repr = m.toFormat(format2);
                System.out.print(repr);
                if (!repr.endsWith("\n")) {
                    System.out.println();
                }
                if (--n2 != 0) continue;
                continue block0;
            }
        }
    }

    static File[] findFiles(String dirName) {
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            System.err.println(dirName + " is not a valid directory");
            System.exit(1);
        }
        return dir.listFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void select(List<File> files, List<Molecule> res, int n) throws IOException {
        int fileNum = rnd.nextInt(files.size());
        File file = files.get(fileNum);
        MolImporter imp = null;
        try {
            imp = new MolImporter(file, null);
            SelectRandomMolecules.select(imp, res, n);
        }
        catch (IOException e) {
            SelectRandomMolecules.remove(fileNum, files);
        }
        finally {
            if (imp != null) {
                imp.close();
            }
        }
        if (verbose) {
            System.err.println("Read " + res.size() + " structures from " + file.getPath());
        }
    }

    static void select(MolImporter imp, List<Molecule> res, int n) throws IOException {
        if (!imp.skipRecord() && verbose) {
            System.err.println("File " + imp.getFileName() + " contains no molecules");
        }
        int rank = 0;
        while (rank < n) {
            while (rnd.nextFloat() > (float)n / (float)imp.estimateNumRecords()) {
                if (imp.skipRecord()) continue;
                return;
            }
            Molecule m = imp.read();
            if (m == null) {
                return;
            }
            ++rank;
            if (verbose) {
                System.err.println("Selecting molecule " + imp.getRecordCount() + "/~" + imp.estimateNumRecords() + " from file " + imp.getFileName() + " (" + rank + "/" + n + ")");
            }
            res.add(m);
        }
    }

    static void remove(int num, List<File> l) {
        if (verbose) {
            File f = l.get(num);
            System.err.println("File " + f.getPath() + " does not contain structures, ignoring");
        }
        l.remove(num);
        if (l.isEmpty()) {
            System.err.println("No structure file found in " + dirName);
            System.exit(2);
        }
    }

    static {
        rnd = new Random();
    }
}

