/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.core.util.BondTable;
import chemaxon.struc.MoleculeGraph;

public class ShortestPath {
    protected int nNodes = 0;
    protected int maxNodes = 0;
    private int[][] pred = null;
    private int[][] d = null;

    public void calculate(MoleculeGraph mg) {
        this.nNodes = mg.getAtomCount();
        BondTable bTab = mg.getBondTable();
        this.alloc();
        this.init(bTab);
        for (int k = 0; k < this.nNodes; ++k) {
            for (int j = 0; j < this.nNodes; ++j) {
                for (int i = 0; i < this.nNodes; ++i) {
                    int s = this.d[i][k] + this.d[k][j];
                    if (s >= this.d[i][j]) continue;
                    this.d[i][j] = s;
                    this.pred[i][j] = this.pred[k][j];
                }
            }
        }
    }

    public int minDist(int a, int b) {
        return this.d[a][b];
    }

    public int getPath(int a, int b, int[] nodes) {
        int len = 0;
        while (this.pred[a][b] != -1 && a != b) {
            nodes[len++] = b;
            b = this.pred[a][b];
        }
        nodes[len++] = a;
        return len;
    }

    private void init(BondTable bTab) {
        for (int i = 0; i < this.nNodes; ++i) {
            for (int j = i + 1; j < this.nNodes; ++j) {
                if (bTab.getBondIndex(i, j) > -1) {
                    this.d[i][j] = 1;
                    this.d[j][i] = 1;
                    this.pred[i][j] = i;
                    this.pred[j][i] = j;
                    continue;
                }
                this.d[i][j] = this.nNodes;
                this.d[j][i] = this.nNodes;
                this.pred[i][j] = -1;
                this.pred[j][i] = -1;
            }
        }
    }

    private void init(int[][] bTab) {
        for (int i = 0; i < this.nNodes; ++i) {
            for (int j = i + 1; j < this.nNodes; ++j) {
                if (bTab[i][j] > -1) {
                    this.d[i][j] = 1;
                    this.d[j][i] = 1;
                    this.pred[i][j] = i;
                    this.pred[j][i] = j;
                    continue;
                }
                this.d[i][j] = this.nNodes;
                this.d[j][i] = this.nNodes;
                this.pred[i][j] = -1;
                this.pred[j][i] = -1;
            }
        }
    }

    private void alloc() {
        if (this.nNodes > this.maxNodes) {
            this.maxNodes = this.nNodes;
            this.pred = new int[this.nNodes][this.nNodes];
            this.d = new int[this.nNodes][this.nNodes];
        }
    }

    public void setNNodes(int nNodes) {
        this.nNodes = nNodes;
        this.pred = new int[nNodes][nNodes];
        this.d = new int[nNodes][nNodes];
    }

    public void calculate(int[][] btab) {
        this.init(btab);
        for (int k = 0; k < this.nNodes; ++k) {
            for (int j = 0; j < this.nNodes; ++j) {
                for (int i = 0; i < this.nNodes; ++i) {
                    int s = this.d[i][k] + this.d[k][j];
                    if (s >= this.d[i][j]) continue;
                    this.d[i][j] = s;
                    this.pred[i][j] = this.pred[k][j];
                }
            }
        }
    }

    public void calculate(BondTable btab) {
        this.init(btab);
        for (int k = 0; k < this.nNodes; ++k) {
            for (int j = 0; j < this.nNodes; ++j) {
                for (int i = 0; i < this.nNodes; ++i) {
                    int s = this.d[i][k] + this.d[k][j];
                    if (s >= this.d[i][j]) continue;
                    this.d[i][j] = s;
                    this.pred[i][j] = this.pred[k][j];
                }
            }
        }
    }
}

