/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.beans.splash.MarvinSplashScreen;
import chemaxon.marvin.version.VersionInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class SplashScreenUtils {
    public static final String BACKGROUND_IMAGE = "Background_Image";
    public static final String COPYRIGHT_FONT = "Copyright_Font";
    public static final String COPYRIGHT_COLOR = "Copyright_Color";
    public static final String COPYRIGHT_POSITION = "Copyright_Position";
    public static final String LICENSE_INFORMATION = "License_Information";
    public static final String LICENSE_FONT = "License_Font";
    public static final String LICENSE_COLOR = "License_Color";
    public static final String LICENSE_POSITION = "License_Position";
    public static final String VERSION_FONT = "Version_Font";
    public static final String VERSION_STROKE_COLOR = "Version_Stroke_Color";
    public static final String VERSION_FILL_COLOR = "Version_Fill_Color";
    public static final String VERSION_POSITION = "Version_Position";
    private static final int SPLASH_WIDTH = 525;
    private static final int SPLASH_HEIGHT = 278;
    private static Font DEFAULT_FONT = null;
    private static final Comparator<String> expirationComparator;

    private SplashScreenUtils() {
    }

    public static final Image getSplashScreen(Product product, URL url) {
        BufferedImage image = new BufferedImage(525, 278, 5);
        ImageIcon img = url == null ? null : new ImageIcon(url);
        SplashScreenUtils.paintSplashScreen(((Image)image).getGraphics(), product, img == null ? null : img.getImage());
        return image;
    }

    public static final Image getSplashScreen(Product product, Image background) {
        BufferedImage image = new BufferedImage(525, 278, 5);
        SplashScreenUtils.paintSplashScreen(((Image)image).getGraphics(), product, background);
        return image;
    }

    public static final void paintSplashScreen(Graphics g, Product product, Image background) {
        Properties properties = SplashScreenUtils.getProperties(product);
        if (background != null) {
            properties.put(BACKGROUND_IMAGE, background);
        }
        SplashScreenUtils.paintSplashScreen(g, properties);
    }

    public static void showSplashScreen(Product product, URL url) {
        MarvinSplashScreen marvinSplash;
        final SplashScreen vmSplash = SplashScreen.getSplashScreen();
        if (vmSplash == null) {
            MarvinSplashScreen.splash(url);
            marvinSplash = MarvinSplashScreen.getInstance();
        } else {
            marvinSplash = null;
        }
        final Image image = SplashScreenUtils.getSplashScreen(product, url);
        final Timer timer = new Timer(50, null);
        timer.addActionListener(new ActionListener(){
            float alpha = 0.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                Graphics2D g2;
                this.alpha += 0.1f;
                if (this.alpha > 1.0f) {
                    this.alpha = 1.0f;
                    timer.stop();
                    timer.removeActionListener(this);
                }
                if (vmSplash != null && vmSplash.isVisible()) {
                    Graphics2D g22 = vmSplash.createGraphics();
                    g22.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    g22.drawImage(image, 0, 0, null);
                    g22.dispose();
                    vmSplash.update();
                } else if (marvinSplash != null && (g2 = marvinSplash.createGraphics()) != null) {
                    g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    g2.drawImage(image, 0, 0, null);
                    g2.dispose();
                    marvinSplash.repaint();
                }
            }
        });
        timer.start();
    }

    public static final void paintSplashScreen(Graphics g, Properties properties) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Object bgr = properties.get(BACKGROUND_IMAGE);
        if (bgr instanceof Image) {
            g2.drawImage((Image)bgr, 0, 0, null);
        }
        Object versionStrokeColor = properties.get(VERSION_STROKE_COLOR);
        Object versionFillColor = properties.get(VERSION_FILL_COLOR);
        Object versionFont = properties.get(VERSION_FONT);
        Object versionPosition = properties.get(VERSION_POSITION);
        if (versionStrokeColor instanceof Color && versionFillColor instanceof Color && versionFont instanceof Font && versionPosition instanceof int[] && ((int[])versionPosition).length > 1) {
            Graphics2D gVersion = (Graphics2D)g2.create();
            gVersion.setFont((Font)versionFont);
            SplashScreenUtils.drawHollowedText(gVersion, "version " + VersionInfo.MARVIN_MAJOR_VERSION, (Color)versionStrokeColor, (Color)versionFillColor, ((int[])versionPosition)[0], ((int[])versionPosition)[1]);
            gVersion.dispose();
        }
        Object copyrightColor = properties.get(COPYRIGHT_COLOR);
        Object copyrightFont = properties.get(COPYRIGHT_FONT);
        Object copyrightPosition = properties.get(COPYRIGHT_POSITION);
        if (copyrightColor instanceof Color && copyrightFont instanceof Font && copyrightPosition instanceof int[] && ((int[])copyrightPosition).length > 1) {
            Graphics2D gCopy = (Graphics2D)g2.create();
            gCopy.setFont((Font)copyrightFont);
            gCopy.setColor((Color)copyrightColor);
            SplashScreenUtils.drawTextToPosition(gCopy, SplashScreenUtils.getCopyrightText((Font)copyrightFont), ((int[])copyrightPosition)[0], ((int[])copyrightPosition)[1]);
            gCopy.dispose();
        }
        Object licenseColor = properties.get(LICENSE_COLOR);
        Object licenseFont = properties.get(LICENSE_FONT);
        Object licensePosition = properties.get(LICENSE_POSITION);
        Object licenseInformation = properties.get(LICENSE_INFORMATION);
        if (licenseInformation instanceof String && licenseColor instanceof Color && licenseFont instanceof Font && licensePosition instanceof int[] && ((int[])licensePosition).length > 1) {
            Graphics2D gLicense = (Graphics2D)g2.create();
            gLicense.setFont((Font)licenseFont);
            gLicense.setColor((Color)licenseColor);
            SplashScreenUtils.drawTextToPosition(gLicense, (String)licenseInformation, ((int[])licensePosition)[0], ((int[])licensePosition)[1]);
            gLicense.dispose();
        }
        g2.dispose();
    }

    private static final String getCopyrightText(Font font) {
        StringBuilder builder = new StringBuilder("Copyright");
        builder.append(font.canDisplay('\u00a9') ? "\u00a9 " : " (c) ");
        builder.append(VersionInfo.buildDate().split("-")[0]);
        builder.append(", ChemAxon Ltd.");
        return builder.toString();
    }

    private static void drawTextToPosition(Graphics g, String text, int x, int y) {
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(x < 0 ? 525 + x - SwingUtilities.computeStringWidth(g.getFontMetrics(g2.getFont()), lines[i]) : x, y < 0 ? 278 + y : y);
            g2.drawString(lines[i], 0, i * g2.getFontMetrics().getHeight());
            g2.dispose();
        }
    }

    private static void drawHollowedText(Graphics g, String text, Color strokeColor, Color fillColor, double x, double y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x < 0.0 ? 525.0 + x - (double)SwingUtilities.computeStringWidth(g.getFontMetrics(g2.getFont()), text) : x, y < 0.0 ? 278.0 + y : y);
        g2.setColor(strokeColor);
        g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
        g2.drawString(text, -1, 0);
        g2.drawString(text, 1, 0);
        g2.drawString(text, 0, -1);
        g2.drawString(text, 0, 1);
        g2.setColor(fillColor);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawString(text, 0, 0);
        g2.dispose();
    }

    private static Properties getProperties(Product product) {
        Properties props = new Properties();
        switch (product) {
            case Standardizer: {
                Color standardizerColor = new Color(60, 80, 169);
                props.put(COPYRIGHT_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(COPYRIGHT_COLOR, standardizerColor);
                props.put(COPYRIGHT_POSITION, new int[]{-5, 205});
                props.put(VERSION_FONT, DEFAULT_FONT.deriveFont(1, 18.0f));
                props.put(VERSION_STROKE_COLOR, standardizerColor);
                props.put(VERSION_FILL_COLOR, Color.WHITE);
                props.put(VERSION_POSITION, new int[]{-5, 187});
                props.put(LICENSE_INFORMATION, SplashScreenUtils.getLicenseInformation("Standardizer"));
                props.put(LICENSE_COLOR, standardizerColor);
                props.put(LICENSE_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(LICENSE_POSITION, new int[]{5, 205});
                break;
            }
            case Reactor: {
                Color reactorColor = new Color(17, 133, 72);
                props.put(COPYRIGHT_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(COPYRIGHT_COLOR, reactorColor);
                props.put(COPYRIGHT_POSITION, new int[]{-5, 205});
                props.put(VERSION_FONT, DEFAULT_FONT.deriveFont(1, 18.0f));
                props.put(VERSION_STROKE_COLOR, reactorColor);
                props.put(VERSION_FILL_COLOR, Color.WHITE);
                props.put(VERSION_POSITION, new int[]{-5, 187});
                props.put(LICENSE_INFORMATION, SplashScreenUtils.getLicenseInformation("Reactor"));
                props.put(LICENSE_COLOR, reactorColor);
                props.put(LICENSE_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(LICENSE_POSITION, new int[]{5, 205});
                break;
            }
            case Structure_Checker: {
                Color structureCheckerColor = new Color(206, 1, 0);
                props.put(COPYRIGHT_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(COPYRIGHT_COLOR, structureCheckerColor);
                props.put(COPYRIGHT_POSITION, new int[]{-5, 205});
                props.put(VERSION_FONT, DEFAULT_FONT.deriveFont(1, 18.0f));
                props.put(VERSION_STROKE_COLOR, structureCheckerColor);
                props.put(VERSION_FILL_COLOR, Color.WHITE);
                props.put(VERSION_POSITION, new int[]{-5, 187});
                props.put(LICENSE_INFORMATION, SplashScreenUtils.getLicenseInformation("Structure Checker"));
                props.put(LICENSE_COLOR, structureCheckerColor);
                props.put(LICENSE_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(LICENSE_POSITION, new int[]{5, 205});
                break;
            }
            case Metabolizer: {
                props.put(COPYRIGHT_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(COPYRIGHT_COLOR, Color.WHITE);
                props.put(COPYRIGHT_POSITION, new int[]{-10, 150});
                props.put(VERSION_FONT, DEFAULT_FONT.deriveFont(1, 18.0f));
                props.put(VERSION_STROKE_COLOR, Color.WHITE);
                props.put(VERSION_FILL_COLOR, new Color(13, 99, 134));
                props.put(VERSION_POSITION, new int[]{-10, 170});
                props.put(LICENSE_INFORMATION, SplashScreenUtils.getLicenseInformation("Metabolizer"));
                props.put(LICENSE_COLOR, Color.WHITE);
                props.put(LICENSE_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(LICENSE_POSITION, new int[]{10, 225});
                break;
            }
            case MarvinSketch: {
                props.put(COPYRIGHT_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(COPYRIGHT_COLOR, new Color(135, 218, 250));
                props.put(COPYRIGHT_POSITION, new int[]{-5, 155});
                props.put(VERSION_FONT, DEFAULT_FONT.deriveFont(1, 18.0f));
                props.put(VERSION_STROKE_COLOR, new Color(68, 141, 192));
                props.put(VERSION_FILL_COLOR, new Color(14, 78, 122));
                props.put(VERSION_POSITION, new int[]{-5, 140});
                break;
            }
            case MarvinSketch_NET: {
                props.put(COPYRIGHT_FONT, DEFAULT_FONT.deriveFont(10.0f));
                props.put(COPYRIGHT_COLOR, new Color(249, 169, 132));
                props.put(COPYRIGHT_POSITION, new int[]{-5, 155});
                props.put(VERSION_FONT, DEFAULT_FONT.deriveFont(1, 18.0f));
                props.put(VERSION_STROKE_COLOR, new Color(187, 98, 64));
                props.put(VERSION_FILL_COLOR, new Color(125, 42, 12));
                props.put(VERSION_POSITION, new int[]{-5, 140});
            }
        }
        return props;
    }

    private static String getLicenseInformation(String productName) {
        String licensee = null;
        String expires = null;
        for (License license : LicenseHandler.getInstance().getLicenses("Standardizer", null)) {
            if ("Never".equals(license.getExpirationDate())) {
                licensee = license.getLicensee();
                expires = "Never";
                break;
            }
            if (expires == null) {
                licensee = license.getLicensee();
                expires = license.getExpirationDate();
                continue;
            }
            if (expirationComparator.compare(expires, license.getExpirationDate()) <= 0) continue;
            licensee = license.getLicensee();
            expires = license.getExpirationDate();
        }
        StringBuilder builder = new StringBuilder("Licensed to ");
        builder.append(licensee);
        if (expires != null) {
            builder.append("\nExpires: ");
            builder.append(expires);
        }
        return builder.toString();
    }

    static {
        HashSet<String> availableFonts = new HashSet<String>(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        for (String preferredFont : new String[]{"Tahoma", "Geneva", "Verdana", "Arial", "Helvetica"}) {
            if (!availableFonts.contains(preferredFont)) continue;
            DEFAULT_FONT = new Font(preferredFont, 0, 32);
            break;
        }
        if (DEFAULT_FONT == null) {
            DEFAULT_FONT = new Font("Lucida Sans", 0, 32);
        }
        expirationComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if ("Never".equals(o1)) {
                    if ("Never".equals(o2)) {
                        return 0;
                    }
                    return 1;
                }
                if ("Never".equals(o2)) {
                    return -1;
                }
                String[] _o1 = o1.split("-");
                String[] _o2 = o2.split("-");
                int count = Math.min(_o1.length, _o2.length);
                for (int i = 0; i < count; ++i) {
                    int n1 = 0;
                    int n2 = 0;
                    try {
                        n1 = Integer.parseInt(_o1[i]);
                    }
                    catch (NumberFormatException e) {
                        n1 = 0;
                    }
                    try {
                        n2 = Integer.parseInt(_o2[i]);
                    }
                    catch (NumberFormatException e) {
                        n2 = 0;
                    }
                    if (n1 == n2) continue;
                    return new Integer(n1).compareTo(n2);
                }
                if (_o1.length != _o2.length) {
                    return _o1.length - _o2.length;
                }
                return 0;
            }
        };
    }

    public static enum Product {
        Metabolizer,
        MarvinSketch,
        MarvinSketch_NET,
        Reactor,
        Standardizer,
        Structure_Checker;

    }
}

