/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.HttpStreamToFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class UploadThread
extends Thread {
    private HttpStreamToFile httpSTF;
    private boolean finished = false;
    private boolean success = false;
    private int StreamLength;
    private Exception error = null;

    public void setParams(String type, int length, InputStream is) {
        try {
            this.httpSTF = new HttpStreamToFile(type, length, is);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.StreamLength = length;
    }

    public void setParams(String type, int length, InputStream is, String dir) {
        try {
            this.httpSTF = new HttpStreamToFile(type, length, is, dir);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.StreamLength = length;
    }

    public void setParams(String type, int length, InputStream is, String dir, String tmp) {
        try {
            this.httpSTF = new HttpStreamToFile(type, length, is, dir, tmp);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.StreamLength = length;
    }

    public String getFileContent() {
        return this.httpSTF.getFileContent();
    }

    public synchronized int getData() {
        return this.httpSTF.getSavedData();
    }

    public String getFileName() {
        return this.httpSTF.getFileName();
    }

    public synchronized File getFile() {
        return this.httpSTF.getFile();
    }

    public int getFileSize() {
        return this.httpSTF.getFileSize();
    }

    public String getDefaultFileName() {
        return this.httpSTF.getOldFileName();
    }

    public Enumeration getParameterNames() {
        return this.httpSTF.getParameterNames();
    }

    public String getParameter(String name) {
        return this.httpSTF.getParameter(name);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean f) {
        this.finished = f;
        this.httpSTF.setFinished(f);
    }

    public synchronized int getPercent() {
        int savedLength = this.httpSTF.getSavedData();
        return (int)Math.ceil((double)savedLength / (double)this.StreamLength * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.success = false;
            this.httpSTF.readAndSaveRequest();
            if (this.getData() == this.StreamLength) {
                this.success = true;
                this.error = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error = e;
        }
        finally {
            this.finished = true;
        }
    }

    public boolean getSuccess() {
        return this.success;
    }

    public Exception getError() {
        return this.error;
    }
}

