/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.cache;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class CachedPools {
    private Map cache = new HashMap();
    private List flatItemList = new LinkedList();
    private int maxSize = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCreatePoolItem(Object key) throws Exception {
        Object poolItem = null;
        List pool = null;
        Map map = this.cache;
        synchronized (map) {
            KeyedPoolItem keyedPoolItem;
            pool = (List)this.cache.get(key);
            poolItem = pool == null || pool.size() == 0 ? this.createPoolItem(key) : ((keyedPoolItem = (KeyedPoolItem)pool.get(0)) == null ? this.createPoolItem(key) : keyedPoolItem.removeFromCache(false));
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recyclePoolItem(Object key, Object poolItem) {
        Map map = this.cache;
        synchronized (map) {
            LinkedList<KeyedPoolItem> pool;
            if (this.size() + 1 > this.maxSize) {
                this.removeLru();
            }
            if ((pool = (LinkedList<KeyedPoolItem>)this.cache.get(key)) == null) {
                pool = new LinkedList<KeyedPoolItem>();
                this.cache.put(key, pool);
            }
            KeyedPoolItem keyedPoolItem = new KeyedPoolItem(key, poolItem);
            pool.add(keyedPoolItem);
            this.flatItemList.add(keyedPoolItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int newMaxSize) {
        if (newMaxSize < 1) {
            throw new IllegalArgumentException("" + newMaxSize);
        }
        Map map = this.cache;
        synchronized (map) {
            this.maxSize = newMaxSize;
            while (newMaxSize < this.size()) {
                this.removeLru();
            }
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    private void removeLru() {
        KeyedPoolItem oldest = (KeyedPoolItem)this.flatItemList.get(0);
        oldest.removeFromCache(true);
    }

    public int size() {
        return this.flatItemList.size();
    }

    protected abstract Object createPoolItem(Object var1) throws Exception;

    public static void main(String[] args) throws Exception {
        CPA cpa = CPA.cache;
        String key = "First";
        String s = (String)cpa.getCreatePoolItem(key);
        CachedPools.trace("Got " + s);
        String s1 = (String)cpa.getCreatePoolItem(key);
        CachedPools.trace("Got " + s1);
        String s2 = (String)cpa.getCreatePoolItem("Second");
        CachedPools.trace("Got " + s2);
        String s3 = (String)cpa.getCreatePoolItem("Second");
        CachedPools.trace("Got " + s3);
        cpa.recyclePoolItem("Second", s3);
        cpa.recyclePoolItem("Second", s2);
        cpa.recyclePoolItem(key, s);
        cpa.recyclePoolItem(key, s1);
        cpa.setMaxSize(2);
        cpa.printSize();
        s2 = (String)cpa.getCreatePoolItem("Second");
        CachedPools.trace("Got " + s2);
        s1 = (String)cpa.getCreatePoolItem(key);
        CachedPools.trace("Got " + s1);
        cpa.recyclePoolItem("First", s1);
        cpa.recyclePoolItem("Second", s2);
        cpa.setMaxSize(2);
        cpa.printSize();
    }

    public void printSize() {
        CachedPools.trace(this.getClass().getName() + ": size=" + this.size());
    }

    private static void trace(String message) {
        System.err.println(message);
    }

    private static class CPA
    extends CachedPools {
        public static CPA cache = new CPA();

        private CPA() {
        }

        @Override
        protected Object createPoolItem(Object key) throws Exception {
            return new String(key.toString());
        }
    }

    private class KeyedPoolItem {
        private Object poolKey;
        private Object poolItem;

        private KeyedPoolItem(Object poolKey, Object poolItem) {
            this.poolKey = poolKey;
            this.poolItem = poolItem;
        }

        private Object removeFromCache(boolean removeEmptyParentPool) {
            List parentPool = (List)CachedPools.this.cache.get(this.poolKey);
            if (!parentPool.remove(this)) {
                throw new IllegalStateException(this + " is not contained in " + parentPool);
            }
            if (removeEmptyParentPool && parentPool.size() == 0) {
                CachedPools.this.cache.remove(this.poolKey);
            }
            CachedPools.this.flatItemList.remove(this);
            return this.poolItem;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

