/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.cache;

import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.util.cache.CachedPools;

public class ChemJepCacheMolContext
extends CachedPools {
    private static ChemJepCacheMolContext chemJepCache = new ChemJepCacheMolContext();
    private Evaluator evaluator;

    public ChemJepCacheMolContext() {
        this.setMaxSize(10000);
    }

    @Override
    public Object createPoolItem(Object key) throws Exception {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator();
        }
        String expression = (String)key;
        return this.evaluator.compile(expression, MolContext.class);
    }

    public static ChemJEP getCreateChemJep(String expression) throws Exception {
        return (ChemJEP)chemJepCache.getCreatePoolItem(expression);
    }

    public static void recycleChemJep(String expression, ChemJEP chemJep) {
        chemJepCache.recyclePoolItem(expression, chemJep);
    }
}

