/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors;

import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.InOutQueuedWorkerFactory;
import chemaxon.util.concurrent.processors.InputOrderedWorkUnitProcessor;
import chemaxon.util.concurrent.processors.SingleThreadedProcessor;
import chemaxon.util.concurrent.processors.UnorderedWorkUnitProcessor;
import chemaxon.util.concurrent.processors.WorkUnitData;
import chemaxon.util.concurrent.processors.WorkUnitProcessorBase;
import chemaxon.util.concurrent.processors.pooledwu.InputOrderedPooledWorkUnitProcessor;
import chemaxon.util.concurrent.processors.pooledwu.PooledWorkUnitProcessorBase;
import chemaxon.util.concurrent.processors.pooledwu.UnorderedPooledWorkUnitProcessor;
import chemaxon.util.concurrent.processors.pooledwu.inputadapt.PooledWorkUnitInputAdapter;
import chemaxon.util.concurrent.util.CallableToWorkUnitAdapter;
import chemaxon.util.concurrent.worker.Worker;
import java.util.concurrent.BlockingQueue;

public final class ConcurrentProcessors {
    public static final int UNORDERED = 0;
    public static final int IN_INPUT_ORDER = 1;
    public static final int SINGLE_THREADED = 2;

    private ConcurrentProcessors() {
    }

    public static final ConcurrentProcessor create(int resultOrder, InputProducer callableProducer) {
        WorkUnitFactory workUnitFactory = new WorkUnitFactory(){

            @Override
            public WorkUnit createWorkUnit() throws Exception {
                return new CallableToWorkUnitAdapter();
            }
        };
        return ConcurrentProcessors.create(resultOrder, callableProducer, workUnitFactory);
    }

    public static final ConcurrentProcessor create(int processorType, InputProducer workUnitInputProducer, WorkUnitFactory workUnitFactory) {
        ConcurrentProcessor wup = null;
        switch (processorType) {
            case 0: {
                InOutQueuedWorkerFactory workerFactory = new InOutQueuedWorkerFactory(){

                    @Override
                    public Worker createWorker(InputProducer inputProducer, WorkUnit workUnit, BlockingQueue<WorkUnitData> outputQueue) {
                        return new UnorderedWorkUnitProcessor(inputProducer, workUnit, outputQueue);
                    }
                };
                workerFactory.setInputProducer(workUnitInputProducer);
                workerFactory.setWorkUnitFactory(workUnitFactory);
                wup = new WorkUnitProcessorBase(workerFactory);
                break;
            }
            case 1: {
                InOutQueuedWorkerFactory workerFactory = new InOutQueuedWorkerFactory(){

                    @Override
                    public Worker createWorker(InputProducer inputProducer, WorkUnit workUnit, BlockingQueue<WorkUnitData> outputQueue) {
                        return new InputOrderedWorkUnitProcessor(inputProducer, workUnit, outputQueue);
                    }
                };
                workerFactory.setInputProducer(workUnitInputProducer);
                workerFactory.setWorkUnitFactory(workUnitFactory);
                wup = new WorkUnitProcessorBase(workerFactory);
                break;
            }
            case 2: {
                wup = new SingleThreadedProcessor(workUnitInputProducer, workUnitFactory);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown processor type: " + processorType);
            }
        }
        return wup;
    }

    public static final ConcurrentProcessor createPooledWu(int resultOrder, InputProducer workUnitInputProducer, WorkUnitFactory workUnitFactory) throws Exception {
        PooledWorkUnitProcessorBase wup = null;
        PooledWorkUnitInputAdapter inputProducer = new PooledWorkUnitInputAdapter(workUnitInputProducer, workUnitFactory);
        switch (resultOrder) {
            case 0: {
                wup = new UnorderedPooledWorkUnitProcessor();
                break;
            }
            case 1: {
                wup = new InputOrderedPooledWorkUnitProcessor();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown result order:" + resultOrder);
            }
        }
        return wup;
    }
}

