/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors;

import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.processors.InputProducerException;
import chemaxon.util.concurrent.processors.ScheduledWorkUnitData;
import chemaxon.util.concurrent.processors.WorkUnitData;
import chemaxon.util.concurrent.processors.WorkUnitException;
import chemaxon.util.concurrent.processors.WorkUnitWorker;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

final class InputOrderedWorkUnitProcessor<V>
extends WorkUnitWorker<V> {
    private static final Logger logger = Logger.getLogger(InputOrderedWorkUnitProcessor.class.getName());

    public InputOrderedWorkUnitProcessor(InputProducer inputProducer, WorkUnit workUnit, BlockingQueue<WorkUnitData> outputQueue) {
        super(inputProducer, workUnit, outputQueue);
    }

    @Override
    protected boolean processInput() throws Exception {
        WorkUnitData workUnitInput = this.getNextInput();
        if (workUnitInput.getError() != null) {
            return !workUnitInput.isInterrupted();
        }
        if (workUnitInput.isPoisoned()) {
            return false;
        }
        this.process(workUnitInput);
        return true;
    }

    protected void process(WorkUnitData input) {
        try {
            this.workUnit.setInput(input.getInput());
            input.setResult(this.workUnit.call());
        }
        catch (InterruptedException interruptedException) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "interruptedException", interruptedException);
            }
            input.setInterrupted();
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "error", throwable);
            }
            input.setError(new WorkUnitException(throwable));
        }
    }

    public void setInput(Object obj) {
        throw new UnsupportedOperationException();
    }

    protected WorkUnitData getNextInput() {
        return this.getNextInputWaitForOuputQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkUnitData getNextInputImmediate() {
        Object input = WorkUnitData.POISONOUS_INPUT;
        ScheduledWorkUnitData scheduledWorkUnitData = new ScheduledWorkUnitData();
        try {
            InputProducer inputProducer = this.inputProducer;
            synchronized (inputProducer) {
                this.outputQueue.put(scheduledWorkUnitData);
                if (this.inputProducer.hasNext()) {
                    input = this.inputProducer.getNext();
                }
            }
            scheduledWorkUnitData.setInput(input);
        }
        catch (InterruptedException e) {
            scheduledWorkUnitData.setInterrupted();
        }
        catch (Throwable throwable) {
            scheduledWorkUnitData.setInput(WorkUnitData.UNKNOWN_INPUT);
            scheduledWorkUnitData.setError(new InputProducerException(throwable));
        }
        return scheduledWorkUnitData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkUnitData getNextInputWaitForOuputQueue() {
        Object input = WorkUnitData.POISONOUS_INPUT;
        ScheduledWorkUnitData scheduledWorkUnitData = new ScheduledWorkUnitData();
        try {
            InputProducer inputProducer = this.inputProducer;
            synchronized (inputProducer) {
                while (!this.outputQueue.offer(scheduledWorkUnitData) && this.inputProducer.hasNext()) {
                    this.inputProducer.wait();
                }
                if (this.inputProducer.hasNext()) {
                    input = this.inputProducer.getNext();
                }
            }
            scheduledWorkUnitData.setInput(input);
        }
        catch (InterruptedException e) {
            scheduledWorkUnitData.setInterrupted();
        }
        catch (Throwable throwable) {
            scheduledWorkUnitData.setInput(WorkUnitData.UNKNOWN_INPUT);
            scheduledWorkUnitData.setError(new InputProducerException(throwable));
        }
        return scheduledWorkUnitData;
    }
}

