/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors;

import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.processors.InputProducerException;
import chemaxon.util.concurrent.processors.WorkUnitData;
import chemaxon.util.concurrent.processors.WorkUnitException;
import chemaxon.util.concurrent.processors.WorkUnitWorker;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UnorderedWorkUnitProcessor<V>
extends WorkUnitWorker<V> {
    private static final Logger logger = Logger.getLogger(UnorderedWorkUnitProcessor.class.getName());

    public UnorderedWorkUnitProcessor(InputProducer inputProducer, WorkUnit workUnit, BlockingQueue<WorkUnitData> outputQueue) {
        super(inputProducer, workUnit, outputQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processInput() throws Exception {
        WorkUnitData workUnitInput = this.getNextInput();
        try {
            if (workUnitInput.getError() != null) {
                boolean bl = true;
                return bl;
            }
            if (workUnitInput.isPoisoned()) {
                boolean bl = false;
                return bl;
            }
            this.process(workUnitInput);
        }
        finally {
            try {
                this.outputQueue.put(workUnitInput);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkUnitData getNextInput() {
        Object input = WorkUnitData.POISONOUS_INPUT;
        WorkUnitData wuData = new WorkUnitData();
        try {
            InputProducer inputProducer = this.inputProducer;
            synchronized (inputProducer) {
                if (this.inputProducer.hasNext()) {
                    input = this.inputProducer.getNext();
                }
            }
            wuData.setInput(input);
        }
        catch (InterruptedException e) {
            wuData.setInterrupted();
        }
        catch (Throwable throwable) {
            wuData.setInput(WorkUnitData.UNKNOWN_INPUT);
            wuData.setError(new InputProducerException(throwable));
        }
        return wuData;
    }

    protected void process(WorkUnitData input) {
        try {
            this.workUnit.setInput(input.getInput());
            input.setResult(this.workUnit.call());
        }
        catch (InterruptedException interruptedException) {
            input.setInterrupted();
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Error", throwable);
            }
            input.setError(new WorkUnitException(throwable));
        }
    }
}

