/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors;

import chemaxon.util.concurrent.processors.WorkUnitData;
import chemaxon.util.concurrent.util.ConcurrentIterator;
import chemaxon.util.concurrent.util.LogUtil;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class WorkUnitDataIterator
implements ConcurrentIterator {
    private static Logger logger = LogUtil.getLogger(WorkUnitDataIterator.class);
    private WorkUnitData nextResult = WorkUnitData.VOID;

    WorkUnitDataIterator() {
    }

    protected abstract WorkUnitData removeNext() throws InterruptedException, ExecutionException;

    @Override
    public boolean hasNext() throws InterruptedException, ExecutionException {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (this.nextResult.isPoisoned()) {
            return false;
        }
        if (this.nextResult == WorkUnitData.VOID) {
            this.nextResult = this.removeNext();
        }
        boolean poisoned = this.nextResult.isPoisoned();
        if (logger.isLoggable(Level.FINE) && poisoned) {
            logger.fine("POISONED");
        }
        return !poisoned;
    }

    public Object getNext() throws InterruptedException, ExecutionException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        WorkUnitData currentResult = this.nextResult;
        this.nextResult = WorkUnitData.VOID;
        return currentResult.getResult();
    }
}

