/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors.pooledwu.inputadapt;

import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.pooledwu.inputadapt.PoolingInpAcceptorWorkUnit;
import chemaxon.util.concurrent.processors.pooledwu.inputadapt.WorkUnitPool;
import java.util.concurrent.ExecutionException;

public class PooledWorkUnitInputAdapter
implements InputProducer {
    private InputProducer inputProducer;
    private WorkUnitPool cache;
    private Class workUnitClass;

    public PooledWorkUnitInputAdapter(InputProducer inputProducer, WorkUnitFactory workUnitFactory) throws Exception {
        this(inputProducer, workUnitFactory, new PoolingInpAcceptorWorkUnit.SimplePool());
    }

    public PooledWorkUnitInputAdapter(InputProducer inputProducer, WorkUnitFactory workUnitFactory, WorkUnitPool cache) throws Exception {
        this.inputProducer = inputProducer;
        this.cache = cache;
        cache.setWorkUnitFactory(workUnitFactory);
        WorkUnit wu = workUnitFactory.createWorkUnit();
        this.workUnitClass = wu.getClass();
        cache.put(wu);
    }

    @Override
    public Object getNext() throws InterruptedException, ExecutionException {
        PoolingInpAcceptorWorkUnit workUnit = new PoolingInpAcceptorWorkUnit(this.cache, this.workUnitClass);
        workUnit.setInput(this.inputProducer.getNext());
        return workUnit;
    }

    @Override
    public boolean hasNext() throws InterruptedException, ExecutionException {
        return this.inputProducer.hasNext();
    }
}

