/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.util;

import chemaxon.util.concurrent.util.ConcurrentIterator;
import chemaxon.util.concurrent.util.OutputQueue;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;

public class BlockingQueueIterator
implements OutputQueue,
ConcurrentIterator {
    private static final Object VOID = new Object();
    private static final Object POISON = new Object();
    private BlockingQueue blockingQueue;
    private Object nextObject = VOID;

    public BlockingQueueIterator(BlockingQueue blockingQueue) {
        this.blockingQueue = blockingQueue;
    }

    public BlockingQueueIterator(int queueSize) {
        this.blockingQueue = new LinkedBlockingQueue(queueSize);
    }

    @Override
    public void put(Object obj) throws InterruptedException {
        this.blockingQueue.put(obj);
    }

    @Override
    public void close() throws InterruptedException {
        this.blockingQueue.put(POISON);
    }

    private void peekNext() throws InterruptedException {
        if (this.nextObject == VOID) {
            this.nextObject = this.blockingQueue.take();
        }
    }

    @Override
    public boolean hasNext() throws InterruptedException, ExecutionException {
        this.peekNext();
        return this.nextObject != POISON;
    }

    public Object getNext() throws InterruptedException, ExecutionException {
        if (this.hasNext()) {
            return this.nextObject;
        }
        throw new NoSuchElementException();
    }
}

