/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.util;

import chemaxon.util.concurrent.util.ConcurrentIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;

public abstract class ConcurrentIteratorAdapter
implements ConcurrentIterator {
    private static final Object VOID = new Object();
    protected static final Object POISON = new Object();
    private Object nextResult = VOID;

    protected abstract Object removeNext() throws InterruptedException, ExecutionException;

    @Override
    public boolean hasNext() throws InterruptedException, ExecutionException {
        if (this.nextResult == POISON) {
            return false;
        }
        if (this.nextResult == VOID) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            this.nextResult = this.removeNext();
        }
        return this.nextResult != POISON;
    }

    public Object getNext() throws InterruptedException, ExecutionException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object currentResult = this.nextResult;
        this.nextResult = VOID;
        return currentResult;
    }

    protected void close() {
        this.nextResult = VOID;
    }
}

