/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.worker;

import chemaxon.util.concurrent.util.Timeout;
import chemaxon.util.concurrent.worker.Worker;
import chemaxon.util.concurrent.worker.WorkerFactory;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WorkerController<G, R>
implements Callable<G> {
    private static final Logger logger = Logger.getLogger(WorkerController.class.getName());
    private BlockingQueue<Future<R>> completionQueue = new LinkedBlockingQueue<Future<R>>();
    private boolean canceled;
    private Throwable error;
    private Vector<Worker<R>> workers = new Vector(200);
    private G grandResult;
    protected int workerCount;
    protected WorkerFactory<R> workerFactory;
    protected Timeout timeout;

    public WorkerController(int workerCount, Timeout timeout) {
        this.workerCount = workerCount;
        this.timeout = timeout;
    }

    public WorkerController(int workerCount, WorkerFactory<R> workerFactory, Timeout timeout) {
        this.workerCount = workerCount;
        this.workerFactory = workerFactory;
        this.timeout = timeout;
    }

    @Override
    public G call() throws Exception {
        this.startWorkers();
        this.joinWorkers(this.timeout);
        return this.getResult();
    }

    protected G getResult() {
        return this.grandResult;
    }

    protected void startWorkers() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Starting workers...");
        }
        try {
            int i;
            Worker<R> worker = this.createWorker();
            if (worker == null) {
                return;
            }
            if (this.workerCount == 0) {
                this.workerCount = WorkUnitManager.getConcurrDegree(worker);
            }
            for (i = 1; i < this.workerCount; ++i) {
                this.createWorker();
            }
            for (i = 0; i < this.workers.size(); ++i) {
                WorkUnitManager.getInstance().submit(this.workers.get(i));
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Worker started.");
            }
        }
        catch (Throwable tbl) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "An error occurred during start" + tbl);
            }
            this.setError(tbl);
            this.cancel();
        }
    }

    public Throwable getError() {
        return this.error;
    }

    protected void setError(Throwable tbl) {
        if (this.error == null) {
            this.error = tbl;
        }
    }

    protected synchronized Worker<R> createWorker() throws Exception {
        if (this.canceled) {
            return null;
        }
        Worker<R> worker = this.workerFactory.createWorker();
        worker.setCompletionQueue(this.completionQueue);
        this.workers.add(worker);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Worker created.");
        }
        return worker;
    }

    protected void joinWorkers(Timeout timeout) throws Exception {
        for (int ix = 0; ix < this.workerCount; ++ix) {
            try {
                if (Thread.interrupted()) {
                    this.cancel();
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Taking from completion queue...");
                }
                Future<R> f = this.completionQueue.take();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Taken from completion queue");
                }
                this.grandResult = this.processWorkerResult(f.get(timeout.getTimeout(), TimeUnit.MILLISECONDS), this.grandResult);
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("Got result");
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "interruptedException", interruptedException);
                }
                this.cancel();
                continue;
            }
            catch (CancellationException cancellationException) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "cancellationException", cancellationException);
                continue;
            }
            catch (TimeoutException timeoutException) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "timeoutException", timeoutException);
                continue;
            }
            catch (Throwable throwable) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "Error in worker", throwable);
                }
                this.cancel();
                this.setError(throwable);
            }
        }
        Throwable e = this.getError();
        if (e != null) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract G processWorkerResult(R var1, G var2);

    public synchronized void cancel() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("cancel BEGINS");
        }
        if (this.canceled) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Already cancelled");
            }
            return;
        }
        this.canceled = true;
        int cancelCount = 0;
        Iterator<Worker<R>> iter = this.workers.iterator();
        while (iter.hasNext()) {
            try {
                Future future = iter.next();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("About to cancel...");
                }
                if (!future.cancel(true)) continue;
                ++cancelCount;
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, "Error while canceling long running work units." + throwable);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("cancelWorkers: " + cancelCount + " worker(s) cancelled");
        }
    }

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public void setWorkerFactory(WorkerFactory<R> workerFactory) {
        this.workerFactory = workerFactory;
    }
}

