/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.workunitmgmt;

import chemaxon.util.concurrent.util.LogUtil;
import chemaxon.util.concurrent.workunitmgmt.BlockingThreadPoolExecutor;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitType;
import java.util.logging.Level;
import java.util.logging.Logger;

class TextbookWorkUnitType
extends WorkUnitType {
    private static final Logger logger = LogUtil.getLogger(TextbookWorkUnitType.class);

    public TextbookWorkUnitType(String name, double cpuUtilization, double waitTimeRatio) {
        this.setName(name);
        int threadCount = this.getRequiredThreadCount(cpuUtilization, waitTimeRatio);
        this.setConcurrencyDegree(threadCount);
        this.setExecutorService(new BlockingThreadPoolExecutor(threadCount));
    }

    private int getRequiredThreadCount(double cpuUtilization, double waitTimeRatio) {
        int nrThreads = Runtime.getRuntime().availableProcessors() * (int)(cpuUtilization * (1.0 + waitTimeRatio));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + " returning " + nrThreads + " number of threads");
        }
        return nrThreads;
    }
}

