/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.workunitmgmt;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WorkUnitConfig {
    private static Logger logger = Logger.getLogger(WorkUnitConfig.class.getName());
    private String name;
    private int threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentHashMap<String, WorkUnitConfig> getWorkUnitConfigs() throws Exception {
        ConcurrentHashMap<String, WorkUnitConfig> concurrentHashMap;
        String tmConfigFilePath = System.getProperty("chemaxon.threadman.configfile");
        if (tmConfigFilePath == null) {
            return null;
        }
        ConcurrentHashMap<String, WorkUnitConfig> assignments = new ConcurrentHashMap<String, WorkUnitConfig>();
        FileInputStream finstream = new FileInputStream(tmConfigFilePath);
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(finstream);
            Element root = doc.getDocumentElement();
            NodeList poolNodes = root.getElementsByTagName("workunittype");
            List<WorkUnitConfig> poolCfgList = WorkUnitConfig.parseWorkUnitConfigs(poolNodes);
            NodeList assignmentNodes = root.getElementsByTagName("assignment");
            WorkUnitConfig.parseAssignments(assignments, assignmentNodes, poolCfgList);
            concurrentHashMap = assignments;
        }
        catch (Throwable throwable) {
            try {
                finstream.close();
                throw throwable;
            }
            catch (IOException ioException) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Problem reading config file", ioException);
                }
                return null;
            }
        }
        finstream.close();
        return concurrentHashMap;
    }

    private static List<WorkUnitConfig> parseWorkUnitConfigs(NodeList poolNodes) {
        ArrayList<WorkUnitConfig> conflist = new ArrayList<WorkUnitConfig>();
        for (int ix = 0; ix < poolNodes.getLength(); ++ix) {
            Element element = (Element)poolNodes.item(ix);
            String name = element.getAttribute("name");
            String threadCount = element.getAttribute("threadCount");
            WorkUnitConfig tpc = new WorkUnitConfig();
            tpc.name = name;
            tpc.threadCount = Integer.parseInt(threadCount);
            conflist.add(tpc);
        }
        return conflist;
    }

    private static void parseAssignments(ConcurrentHashMap<String, WorkUnitConfig> assignments, NodeList assignmentNodes, List<WorkUnitConfig> poolCfgList) {
        for (int ix = 0; ix < assignmentNodes.getLength(); ++ix) {
            Element element = (Element)assignmentNodes.item(ix);
            String className = element.getAttribute("class");
            String poolName = element.getAttribute("workunittype");
            WorkUnitConfig cfg = WorkUnitConfig.getWorkUnitConfig(poolName, poolCfgList);
            if (cfg == null) {
                throw new IllegalArgumentException("No such pool configured: " + poolName);
            }
            assignments.put(className, cfg);
        }
    }

    private static WorkUnitConfig getWorkUnitConfig(String name, List<WorkUnitConfig> poolCfgList) {
        for (WorkUnitConfig cfg : poolCfgList) {
            if (!cfg.name.equals(name)) continue;
            return cfg;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

