/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.differ;

import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.util.differ.Differ;
import chemaxon.util.differ.MolGraphDiffer;

public class MolDiffer
implements Differ<MoleculeGraph[], Molecule> {
    private MolGraphDiffer graphDiffer = new MolGraphDiffer();

    @Override
    public MoleculeGraph[] diff(Molecule o1, Molecule o2) {
        if (o1 instanceof RgMolecule && o2 instanceof RgMolecule) {
            return this.diff((RgMolecule)o1, (RgMolecule)o2);
        }
        return this.graphDiffer.diff(o1, o2);
    }

    @Override
    private MoleculeGraph[] diff(RgMolecule r1, RgMolecule r2) {
        MoleculeGraph[] result = this.graphDiffer.diff(r1.getRoot(), r2.getRoot());
        if (result == null) {
            result = new MoleculeGraph[]{new SelectionMolecule(), new SelectionMolecule()};
        }
        int n1 = r1.getRgroupCount();
        int n2 = r2.getRgroupCount();
        int n = Math.max(n1, n2);
        for (int i = 0; i < n; ++i) {
            int j;
            int m1 = i < n1 ? r1.getRgroupMemberCount(i) : 0;
            int m2 = i < n2 ? r2.getRgroupMemberCount(i) : 0;
            int m = Math.min(m1, m2);
            for (j = 0; j < m; ++j) {
                MoleculeGraph[] subresult = this.graphDiffer.diff(r1.getRgroupMember(i, j), r2.getRgroupMember(i, j));
                if (subresult == null) continue;
                result[0].fuse(subresult[0]);
                result[1].fuse(subresult[1]);
            }
            for (j = m; j < m1; ++j) {
                result[0].fuse(r1.getRgroupMember(i, j));
            }
            for (j = m; j < m2; ++j) {
                result[0].fuse(r2.getRgroupMember(i, j));
            }
        }
        if (result[0].isEmpty() && result[1].isEmpty()) {
            result = null;
        }
        return result;
    }
}

