/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.differ;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.util.differ.Differ;

public class MolGraphDiffer
implements Differ<MoleculeGraph[], MoleculeGraph> {
    @Override
    public MoleculeGraph[] diff(MoleculeGraph o1, MoleculeGraph o2) {
        MoleculeGraph[] result = new MoleculeGraph[]{new SelectionMolecule(), new SelectionMolecule()};
        this.diffAtoms(result, o1, o2);
        this.diffBonds(result, o1, o2);
        if (result[0].isEmpty() && result[1].isEmpty()) {
            result = null;
        }
        return result;
    }

    private void diffAtoms(MoleculeGraph[] result, MoleculeGraph o1, MoleculeGraph o2) {
        int i;
        int count1 = o1.getAtomCount();
        int count2 = o2.getAtomCount();
        int count = Math.min(count1, count2);
        for (i = 0; i < count; ++i) {
            MolAtom atom2;
            MolAtom atom1 = o1.getAtom(i);
            if (MolGraphDiffer.equal(atom1, atom2 = o2.getAtom(i))) continue;
            result[0].add(atom1);
            result[1].add(atom2);
        }
        for (i = count; i < count1; ++i) {
            result[0].add(o1.getAtom(i));
        }
        for (i = count; i < count2; ++i) {
            result[1].add(o2.getAtom(i));
        }
    }

    private void diffBonds(MoleculeGraph[] result, MoleculeGraph o1, MoleculeGraph o2) {
        this.diffBonds(result[0], result[1], o1, o2);
        this.diffBonds(result[1], result[0], o2, o1);
        MolGraphDiffer.addMissingBondEndAtoms(result[0]);
        MolGraphDiffer.addMissingBondEndAtoms(result[1]);
    }

    private void diffBonds(MoleculeGraph result1, MoleculeGraph result2, MoleculeGraph o1, MoleculeGraph o2) {
        int count = o1.getBondCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom22;
            boolean atom12Differs;
            MolBond bond1 = o1.getBond(i);
            MolAtom atom11 = bond1.getAtom1();
            MolAtom atom12 = bond1.getAtom2();
            boolean atom11Differs = result1.indexOf(atom11) != -1;
            boolean bl = atom12Differs = result1.indexOf(atom12) != -1;
            if (atom11Differs || atom12Differs) {
                result1.add(bond1);
                continue;
            }
            int index1 = o1.indexOf(atom11);
            int index2 = o1.indexOf(atom12);
            MolAtom atom21 = o2.getAtom(index1);
            MolBond bond2 = atom21.getBondTo(atom22 = o2.getAtom(index2));
            if (bond2 != null && MolGraphDiffer.equal(bond1, bond2)) continue;
            result1.add(bond1);
        }
    }

    private static void addMissingBondEndAtoms(MoleculeGraph m) {
        for (int i = m.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = m.getBond(i);
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            if (m.indexOf(atom1) == -1) {
                m.add(atom1);
            }
            if (m.indexOf(atom2) != -1) continue;
            m.add(atom2);
        }
    }

    public static boolean equal(MolAtom atom1, MolAtom atom2) {
        if (atom1.getAtno() != atom2.getAtno()) {
            return false;
        }
        if (atom1.getSetSeq() != atom2.getSetSeq()) {
            return false;
        }
        if (atom1.getParent().isValenceCheckEnabled() && atom1.getImplicitHcount() != atom2.getImplicitHcount()) {
            return false;
        }
        if (!((Object)atom1.propertySet()).equals(atom2.propertySet())) {
            return false;
        }
        switch (atom1.getAtno()) {
            case 135: {
                return atom1.getSymbol().equals(atom2.getSymbol());
            }
            case 136: {
                String alias1 = atom1.getAliasstr();
                String alias2 = atom2.getAliasstr();
                return alias1 == null && alias2 == null || alias1 != null && alias1.equals(alias2);
            }
            case 134: {
                return atom1.getRgroup() == atom2.getRgroup();
            }
        }
        return true;
    }

    public static boolean equal(MolBond bond1, MolBond bond2) {
        if (bond1.getSetSeq() != bond2.getSetSeq()) {
            return false;
        }
        return bond1.getType() == bond2.getType();
    }
}

