/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.util.expression.AtomExpression;
import chemaxon.util.expression.StaticContext;
import java.util.BitSet;

public class AtomSetExpression
extends AtomExpression {
    public AtomSetExpression() {
    }

    public AtomSetExpression(StaticContext staticContext) {
        super(staticContext);
    }

    @Override
    public String getResultType() {
        return "BitSet";
    }

    @Override
    public Object evaluate() throws ParseException {
        this.initEvaluation();
        this.searcherJEP.setDynamicContext(this.dynamicContext);
        this.searcherJEP.evaluate_boolean();
        if (this.dynamicContext == null) {
            throw new ParseException("no dynamic context given");
        }
        Molecule mol = this.dynamicContext.getInputMolecule();
        if (mol == null) {
            throw new ParseException("no input molecule given");
        }
        this.selectorJEP.setDynamicContext(this.dynamicContext);
        int n = mol.getAtomCount();
        BitSet atomset = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            this.dynamicContext.setAtomIndex(i);
            if (!this.selectorJEP.evaluate_boolean()) continue;
            atomset.set(i);
        }
        return atomset;
    }

    @Override
    public boolean evaluate_boolean() throws ParseException {
        BitSet atomset = (BitSet)this.evaluate();
        return atomset.length() > 0;
    }
}

