/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.expression.DynamicContext;
import chemaxon.util.expression.StaticContext;
import java.util.Properties;

public abstract class ChemExpression {
    private String ID = null;
    private boolean top = true;
    protected StaticContext staticContext = null;
    protected DynamicContext dynamicContext = null;

    protected static final String removeWhitespace(String str) {
        StringBuffer s = new StringBuffer();
        boolean instring = false;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                boolean bl = instring = !instring;
            }
            if (!instring && Character.isWhitespace(c)) continue;
            s.append(c);
        }
        return new String(s);
    }

    protected final String insertPluginArg(String text, String arg) throws ParseException {
        if (this.staticContext == null) {
            return text;
        }
        String[] names = this.staticContext.getSortedPluginNames();
        if (names.length == 0) {
            return text;
        }
        int[] nameinds = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            nameinds[i] = text.indexOf(names[i]);
        }
        int len = text.length();
        int k = 0;
        StringBuffer s = new StringBuffer();
        while (k < len) {
            int m = len;
            int j = -1;
            for (int i = 0; i < names.length; ++i) {
                if (nameinds[i] == -1) continue;
                if (nameinds[i] < k) {
                    nameinds[i] = text.indexOf(names[i], k);
                    if (nameinds[i] == -1) continue;
                }
                if (nameinds[i] >= m) continue;
                m = nameinds[i];
                j = i;
            }
            if (j == -1) {
                s.append(text.substring(k));
                break;
            }
            int t = m + names[j].length();
            s.append(text.substring(k, t));
            if (t <= len - 2 && text.charAt(t) == '(') {
                if (text.charAt(t + 1) == ')') {
                    s.append("(" + arg + ")");
                    k = t + 2;
                    continue;
                }
                s.append("(" + arg + ",");
                k = t + 1;
                continue;
            }
            s.append("(" + arg + ")");
            k = t;
        }
        return new String(s);
    }

    protected static final String createCondString(Properties comptable, String logic) throws ParseException {
        StringBuffer s = new StringBuffer();
        String key = "";
        int len = logic.length();
        for (int k = 0; k <= len; ++k) {
            char c;
            char c2 = c = k < len ? (char)logic.charAt(k) : (char)' ';
            if (Character.isDigit(c)) {
                key = key + String.valueOf(c);
                continue;
            }
            if (key.length() > 0) {
                String comp = comptable.getProperty(key);
                if (comp == null) {
                    throw new ParseException("Expression with index " + key + " referenced by the logic " + logic + " does not exist.");
                }
                s.append("(");
                s.append(comp);
                s.append(")");
                key = "";
            }
            if (k >= len || Character.isWhitespace(c)) continue;
            s.append(c);
        }
        return new String(s);
    }

    protected static final void transformFunctionReferences(StringBuffer buffer, String[] names, String arg) throws ParseException {
        int arglen = arg.length();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int len = name.length();
            int k = 0;
            while ((k = ChemExpression.indexOf(buffer, name + "(", k)) != -1) {
                k += len + 1;
                if ((k = ChemExpression.indexOf(buffer, ")", k)) == -1) {
                    throw new ParseException("malformed expression: " + buffer);
                }
                if (buffer.charAt(k - 1) == '(') {
                    buffer.insert(k, arg);
                    k += arglen;
                    continue;
                }
                buffer.insert(k, "," + arg);
                k += arglen + 1;
            }
        }
    }

    protected static final void transformPluginReferences(StringBuffer buffer, String[] names) throws ParseException {
        ChemExpression.transformPluginReferences(buffer, names, null);
    }

    protected static final void transformPluginReferences(StringBuffer buffer, String[] names, String arg) throws ParseException {
        int arglen = arg != null ? arg.length() : 0;
        block6: for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int len = name.length();
            int k = 0;
            int c = 32;
            while ((k = ChemExpression.indexOf(buffer, name, k)) != -1) {
                boolean prevproc = false;
                block8: for (int j = k - 1; j >= 6; --j) {
                    if (buffer.charAt(j) != '(' || buffer.charAt(j - 1) != 'N' || buffer.charAt(j - 2) != 'I' || buffer.charAt(j - 3) != 'G' || buffer.charAt(j - 4) != 'U' || buffer.charAt(j - 5) != 'L' || buffer.charAt(j - 6) != 'P') continue;
                    int z = j + 1;
                    String substr = buffer.substring(z, k + name.length());
                    for (int l = i - 1; l >= 0; --l) {
                        if (!names[l].startsWith(substr)) continue;
                        prevproc = true;
                        break block8;
                    }
                    break;
                }
                if (prevproc) {
                    ++k;
                    continue;
                }
                buffer.insert(k, "PLUGIN(");
                k += 7 + len;
                try {
                    c = buffer.charAt(k);
                }
                catch (IndexOutOfBoundsException e) {
                    buffer.append(")");
                    continue block6;
                }
                if (c != 40) {
                    if (arg != null) {
                        buffer.insert(k, "," + arg + ")");
                        k += 2 + arglen;
                        continue;
                    }
                    buffer.insert(k, ')');
                    ++k;
                    continue;
                }
                try {
                    c = buffer.charAt(k + 1);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ParseException("malformed expression: " + buffer);
                }
                if (c == 41) {
                    if (arg != null) {
                        buffer.setCharAt(k, ',');
                        buffer.insert(k + 1, arg);
                        k += 1 + arglen;
                        continue;
                    }
                    buffer.setCharAt(k, ' ');
                    ++k;
                    continue;
                }
                buffer.setCharAt(k, ',');
                if (arg == null) continue;
                int b = 1;
                while (b > 0) {
                    try {
                        c = buffer.charAt(++k);
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new ParseException("malformed expression: " + buffer);
                    }
                    if (c == 40) {
                        ++b;
                        continue;
                    }
                    if (c != 41) continue;
                    --b;
                }
                buffer.insert(k, "," + arg);
            }
        }
    }

    protected static final int indexOf(StringBuffer buffer, String str, int fromIndex) {
        char firstChar = str.charAt(0);
        int strlen = str.length();
        if (strlen == 0) {
            return -1;
        }
        int len = buffer.length() - strlen + 1;
        for (int k = fromIndex; k < len; ++k) {
            int t;
            if (buffer.charAt(k) != firstChar) continue;
            for (t = 1; t < strlen && buffer.charAt(k + t) == str.charAt(t); ++t) {
            }
            if (t != strlen) continue;
            return k;
        }
        return -1;
    }

    public ChemExpression() {
    }

    public ChemExpression(StaticContext staticContext) {
        this.setStaticContext(staticContext);
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setDynamicContext(DynamicContext dynamicContext) {
        this.dynamicContext = dynamicContext;
    }

    public DynamicContext getDynamicContext() {
        return this.dynamicContext;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    public void setTop(boolean top) {
        this.top = top;
    }

    public boolean isTop() {
        return this.top;
    }

    protected void initEvaluation() throws ParseException {
        if (this.top && this.staticContext != null) {
            this.staticContext.initPlugins();
        }
    }

    public abstract String getResultType();

    public abstract void compile(String var1) throws ParseException;

    public abstract Object evaluate() throws ParseException;

    public abstract boolean evaluate_boolean() throws ParseException;
}

