/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.JEP;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.util.expression.DynamicContext;
import chemaxon.util.expression.StaticContext;
import chemaxon.util.expression.function.ChemFunction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ChemJEP
extends JEP {
    private StaticContext staticContext = null;
    private DynamicContext dynamicContext = null;
    private ArrayList chemFunctions = new ArrayList();
    private boolean verbose = false;

    public ChemJEP() {
        this(null);
    }

    public ChemJEP(StaticContext staticContext) {
        this.setAllowUndeclared(true);
        this.setStaticContext(staticContext);
    }

    public void addVariablesAsObject(Hashtable vartab) {
        Enumeration names = vartab.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.addVariableAsObject(name, vartab.get(name));
        }
    }

    public void addFunctions(Hashtable funtab) throws ParseException {
        Enumeration names = funtab.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            PostfixMathCommandI function = (PostfixMathCommandI)funtab.get(name);
            if (function instanceof ChemFunction) {
                this.addChemFunction(name, (ChemFunction)function);
                continue;
            }
            this.addFunction(name, function);
        }
    }

    public void addChemFunction(String functionName, ChemFunction function) throws ParseException {
        this.chemFunctions.add(function);
        this.addFunction(functionName, function);
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setDynamicContext(DynamicContext dynamicContext) {
        this.dynamicContext = dynamicContext;
    }

    public DynamicContext getDynamicContext() {
        return this.dynamicContext;
    }

    public void compile(String expression) throws ParseException {
        this.initCompilation();
        this.parseExpression(expression);
    }

    public Object evaluate() throws ParseException {
        this.initEvaluation();
        return this.getValueAsObject();
    }

    public double evaluate_double() throws ParseException {
        this.initEvaluation();
        return this.getValue();
    }

    public boolean evaluate_boolean() throws ParseException {
        return this.evaluate_double() > 0.5;
    }

    private void initCompilation() throws ParseException {
        if (this.staticContext != null) {
            this.addVariablesAsObject(this.staticContext.getVariables());
            this.addFunctions(this.staticContext.getFunctions());
        }
        for (int i = this.chemFunctions.size() - 1; i >= 0; --i) {
            ChemFunction function = (ChemFunction)this.chemFunctions.get(i);
            function.setStaticContext(this.staticContext);
        }
    }

    private void initEvaluation() throws ParseException {
        if (this.dynamicContext != null) {
            this.addVariablesAsObject(this.dynamicContext.getVariables());
            for (int i = this.chemFunctions.size() - 1; i >= 0; --i) {
                ChemFunction function = (ChemFunction)this.chemFunctions.get(i);
                function.setInputMolecule(this.dynamicContext.getInputMolecule());
            }
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }
}

