/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import chemaxon.util.SearchAttributes;
import chemaxon.util.expression.AtomSetExpression;
import chemaxon.util.expression.ChemExpression;
import chemaxon.util.expression.DynamicContext;
import chemaxon.util.expression.GeneralExpression;
import chemaxon.util.expression.MolConditionExpression;
import chemaxon.util.expression.MultipleExpression;
import chemaxon.util.expression.StaticContext;
import chemaxon.util.expression.function.ChemFunction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class MolEvaluator {
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = "MolEvaluator, (C) 1999-2012 ChemAxon Ltd." + lineSep + "Molecule expression evaluator." + lineSep + "Usage:" + lineSep + "  evaluate [<input mol file>] [-e <expression> | -f <expression file>]" + lineSep + "  [-y <condition|atomset|general|multiple>] [-c <config file>] [other options]" + lineSep + "" + lineSep + "" + "Options: " + lineSep + "  -h, --help                                this help message" + lineSep + "  -e, --expression \"<expression string>\"    expression string" + lineSep + "  -f, --file <expression file>              expression file" + lineSep + "  -c, --config <config file>                config file" + lineSep + "    , --input                               input molecule file" + lineSep + "  -m, --mol <molecule file>                 molecule file (input context)" + lineSep + "  -y, --type <type>                         expression type" + lineSep + "                                            (condition|atomset|" + lineSep + "                                            general|multiple)" + lineSep + "                                            (default: condition)" + lineSep + "  -o, --output <filepath>                   output file path (default: stdout)" + lineSep + "  -t, --tag                                 name of the SDFile tag" + lineSep + "                                            to store the result" + lineSep + "                                            (default: RESULT)" + lineSep + "  -S, --sdf-output                          SDF output (otherwise result only)" + lineSep + "  -v, --verbose                             verbose output" + lineSep + lineSep + "Examples:" + lineSep + "  evaluate -c Evaluator.xml -e \"mass\" -y general m.mol" + lineSep + "  evaluate -c Evaluator.xml -e \"carboxil:1,2 && charge > 5\" -y atomset m.mol" + lineSep;
    public static final String DEFAULT_TAG_NAME = "RESULT";
    private String dir = null;
    private StaticContext staticContext = new StaticContext();
    private Hashtable functionClasses = new Hashtable();
    private Hashtable functionParams = new Hashtable();

    public void setVerbose(boolean verbose) {
        this.staticContext.setVerbose(verbose);
    }

    public void setConfig(File config) throws IOException, ParseException {
        if (config != null) {
            this.dir = config.getParent();
            this.setConfig(new BufferedInputStream(new FileInputStream(config)));
        }
    }

    public void setConfig(InputStream config) throws IOException, ParseException {
        Element root = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(config);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new ParseException(e);
        }
        this.setConfig(root);
    }

    public void setConfig(Element root, String dir) throws IOException, ParseException {
        this.dir = dir;
        this.setConfig(root);
    }

    public void setConfig(Element root) throws IOException, ParseException {
        Element searchRoot = (Element)root.selectSingleNode("Search");
        Element functionRoot = (Element)root.selectSingleNode("Functions");
        Element pluginRoot = (Element)root.selectSingleNode("Plugins");
        Element molRoot = (Element)root.selectSingleNode("Mols");
        this.init(searchRoot, functionRoot, pluginRoot, molRoot);
    }

    public void init(Element searchRoot, Element functionRoot, Element pluginRoot, Element molRoot) throws IOException, ParseException {
        this.initSearch(searchRoot);
        this.initFunctions(functionRoot);
        this.initPlugins((Node)pluginRoot);
        this.initMols((Node)molRoot);
    }

    public void initSearch(Element searchRoot) {
        if (searchRoot != null) {
            SearchAttributes attributes = this.staticContext.getSearchAttributes();
            if (attributes == null) {
                attributes = new SearchAttributes();
                this.staticContext.setSearchAttributes(attributes);
            }
            String value = null;
            value = searchRoot.attributeValue("StereoSearch", "");
            if (value.equalsIgnoreCase("true")) {
                attributes.setStereoSearch(true);
            } else if (value.equalsIgnoreCase("false")) {
                attributes.setStereoSearch(false);
            }
            value = searchRoot.attributeValue("DoubleBondStereoMatchingMode", "");
            if ("none".equalsIgnoreCase(value)) {
                attributes.setDoubleBondStereoMatchingMode(2);
            } else if ("marked".equalsIgnoreCase(value)) {
                attributes.setDoubleBondStereoMatchingMode(1);
            } else if ("all".equalsIgnoreCase(value)) {
                attributes.setDoubleBondStereoMatchingMode(0);
            }
            value = searchRoot.attributeValue("SubgraphSearch", "");
            if (value.equalsIgnoreCase("true")) {
                attributes.setSubgraphSearch(true);
            } else if (value.equalsIgnoreCase("false")) {
                attributes.setSubgraphSearch(false);
            }
            value = searchRoot.attributeValue("ExactAtomMatching", "");
            if (value.equalsIgnoreCase("true")) {
                attributes.setExactAtomMatching(true);
            } else if (value.equalsIgnoreCase("false")) {
                attributes.setExactAtomMatching(false);
            }
            value = searchRoot.attributeValue("ExactStereoMatching", "");
            if (value.equalsIgnoreCase("true")) {
                attributes.setExactStereoMatching(true);
            } else if (value.equalsIgnoreCase("false")) {
                attributes.setExactStereoMatching(false);
            }
            value = searchRoot.attributeValue("OrderSensitiveSearch", "");
            if (value.equalsIgnoreCase("true")) {
                attributes.setOrderSensitiveSearch(true);
            } else if (value.equalsIgnoreCase("false")) {
                attributes.setOrderSensitiveSearch(false);
            }
        }
    }

    public void initFunctions(Element functionRoot) throws ParseException {
        if (functionRoot != null) {
            List functionNodes = functionRoot.selectNodes("Function");
            int n = functionNodes.size();
            for (int i = 0; i < n; ++i) {
                Element functionNode = (Element)functionNodes.get(i);
                String clname = functionNode.attributeValue("Class");
                String id = functionNode.attributeValue("ID");
                if (clname == null) {
                    throw new ParseException("Function node Class attribute is missing");
                }
                if (id == null) {
                    throw new ParseException("Function node " + clname + ": ID attribute is missing");
                }
                try {
                    Class<?> cl = Class.forName(clname);
                    if (!PostfixMathCommandI.class.isAssignableFrom(cl)) {
                        throw new ParseException("Function node " + clname + ": class does not implement chemaxon.nfunk.jep.function.PostfixMathCommandI");
                    }
                    if (ChemFunction.class.isAssignableFrom(cl)) {
                        this.functionParams.put(id, MolEvaluator.createParameterTable(functionNode));
                    }
                    this.functionClasses.put(id, cl);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new ParseException("Class: " + clname + " is not found.", e);
                }
            }
        }
    }

    private static Properties createParameterTable(Element element) throws ParseException {
        Properties params = new Properties();
        XPath ppath = DocumentHelper.createXPath((String)"Param");
        List plist = ppath.selectNodes((Object)element);
        for (Element pelement : plist) {
            String name = pelement.attributeValue("Name");
            String value = pelement.attributeValue("Value");
            if (name == null || value == null) {
                throw new ParseException("Name and Value attributes are mandatory for Param elements");
            }
            params.put(name, value);
        }
        return params;
    }

    public void setFunctions() throws ParseException {
        Enumeration ids = this.functionClasses.keys();
        while (ids.hasMoreElements()) {
            String id = (String)ids.nextElement();
            Class cl = (Class)this.functionClasses.get(id);
            try {
                Properties params;
                PostfixMathCommandI func = (PostfixMathCommandI)cl.newInstance();
                if (func instanceof ChemFunction && (params = (Properties)this.functionParams.get(id)) != null) {
                    ((ChemFunction)func).setParameters(params);
                }
                this.staticContext.addFunction(id, func);
            }
            catch (InstantiationException e) {
                throw new ParseException(e);
            }
            catch (IllegalAccessException e) {
                throw new ParseException(e);
            }
            catch (ClassCastException e) {
                throw new ParseException(e);
            }
        }
    }

    public void setFunction(String id, PostfixMathCommandI function) {
        this.staticContext.addFunction(id, function);
    }

    public void initPlugins(Node pluginRoot) throws ParseException {
        if (pluginRoot != null) {
            CalculatorPlugin plugin = null;
            List pluginNodes = pluginRoot.selectNodes("Plugin");
            int n = pluginNodes.size();
            for (int i = 0; i < n; ++i) {
                Element pluginElement = (Element)pluginNodes.get(i);
                String id = pluginElement.attributeValue("ID");
                String cl = pluginElement.attributeValue("Class");
                String jar = pluginElement.attributeValue("JAR");
                if (id == null) {
                    throw new ParseException("No ID is given for plugin: " + cl);
                }
                if (cl == null && jar == null) {
                    throw new ParseException("Class or JAR attribute is mandatory for Plugin elements");
                }
                try {
                    plugin = CalculatorPlugin.create(cl, jar);
                }
                catch (PluginException e) {
                    throw new ParseException(e);
                }
                Properties params = new Properties();
                List paramNodes = pluginElement.selectNodes("Param");
                int m = paramNodes.size();
                for (int j = 0; j < m; ++j) {
                    Element paramElement = (Element)paramNodes.get(j);
                    String name = paramElement.attributeValue("Name");
                    String value = paramElement.attributeValue("Value");
                    params.put(name, value);
                }
                try {
                    plugin.setParameters(params);
                }
                catch (PluginException e) {
                    throw new ParseException(e);
                }
                this.staticContext.addPlugin(id, plugin);
            }
        }
    }

    public void initMols(Node molRoot) throws IOException, ParseException {
        if (molRoot != null) {
            Object mol = null;
            List molNodes = molRoot.selectNodes("Mol");
            int n = molNodes.size();
            for (int i = 0; i < n; ++i) {
                Element molElement = (Element)molNodes.get(i);
                String id = molElement.attributeValue("ID");
                String type = molElement.attributeValue("Type");
                String structure = molElement.attributeValue("Structure");
                if (structure == null) {
                    throw new IOException("Structure attribute is mandatory for Mol elements.");
                }
                MolImporter molimp = ConfigTools.getQueryMolImporter(structure, type, this.dir);
                this.addMolConstants(id, molimp);
            }
        }
    }

    private int addMolConstants(String id, MolImporter molimp) throws IOException {
        ArrayList<Molecule> v = new ArrayList<Molecule>();
        Molecule mol = null;
        while ((mol = molimp.read()) != null) {
            v.add(mol);
        }
        int s = v.size();
        if (s == 1) {
            this.staticContext.addConstant(id, v.get(0));
        } else {
            this.staticContext.addConstant(id, v.toArray());
        }
        return s;
    }

    public void setMols(Molecule[] mols) {
        this.staticContext.setMols(mols);
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    private static Molecule[] readMols(InputStream[] in) throws IOException {
        Vector<Molecule> v = new Vector<Molecule>();
        Molecule mol = null;
        for (int i = 0; i < in.length; ++i) {
            MolImporter mi = new MolImporter(in[i]);
            while ((mol = mi.read()) != null) {
                v.add(mol);
            }
        }
        Molecule[] mols = new Molecule[v.size()];
        v.toArray(mols);
        return mols;
    }

    public static void main(String[] args) throws Exception {
        CLQ clq = new CLQ(args, null);
        if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(helptext);
            return;
        }
        String expr = null;
        CLQ.Parameter pExpr = clq.lookup("-e", "--expression", "", 2, false, false);
        CLQ.Parameter pFile = clq.lookup("-f", "--file", "", 2, false, false);
        if (pExpr != null) {
            expr = pExpr.getString();
        } else {
            BufferedReader reader = null;
            reader = pFile != null ? new BufferedReader(new FileReader(pFile.getString())) : new BufferedReader(new InputStreamReader(System.in));
            StringBuffer s = new StringBuffer();
            while ((expr = reader.readLine()) != null) {
                s.append(expr);
            }
            expr = new String(s);
        }
        CLQ.Parameter pConfig = clq.lookup("-c", "--config", "", 2, false, false);
        File config = pConfig != null ? new File(pConfig.getString()) : null;
        CLQ.Parameter pType = clq.lookup("-y", "--type", "", 2, false, false);
        String type = pType != null ? pType.getString() : "condition";
        CLQ.Parameter pVerbose = clq.lookup("-v", "--verbose", "", 1, false, false);
        boolean verbose = pVerbose != null;
        CLQ.Parameter pOs = clq.lookup("-o", "--output", "", 2, false, false);
        PrintStream os = null;
        os = pOs != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(pOs.getString()))) : System.out;
        boolean onlyRESULT = clq.lookup("-S", "--sdf-output", "", 1, false, false) == null;
        CLQ.Parameter pTag = clq.lookup("-t", "--tag", "", 2, false, false);
        String tag = DEFAULT_TAG_NAME;
        if (pTag != null) {
            tag = pTag.getString();
        }
        CLQ.Parameter pMol = clq.lookup("-m", "--mol", "", false, false);
        InputStream[] inm = null;
        String filename = null;
        if (pMol != null) {
            int n = pMol.size();
            inm = new InputStream[n];
            for (int i = 0; i < n; ++i) {
                try {
                    filename = pMol.getString(i);
                    inm[i] = new FileInputStream(filename);
                    continue;
                }
                catch (FileNotFoundException ex) {
                    System.out.println(filename + ": not found");
                    return;
                }
                catch (IOException ex) {
                    System.out.println(filename + ": cannot open");
                    return;
                }
            }
        }
        CLQ.Parameter pIn = clq.lookup("", "--input", "", false, false);
        InputStream[] ini = null;
        if (pIn != null) {
            int n = pIn.size();
            Vector<FileInputStream> v = new Vector<FileInputStream>(n);
            for (int i = 0; i < n; ++i) {
                try {
                    filename = pIn.getString(i);
                    v.add(new FileInputStream(filename));
                    continue;
                }
                catch (FileNotFoundException ex) {
                    System.err.println(filename + ": not found");
                    continue;
                }
                catch (IOException ex) {
                    System.err.println(filename + ": cannot open");
                }
            }
            ini = new InputStream[v.size()];
            v.toArray(ini);
        }
        MolEvaluator me = new MolEvaluator();
        me.setVerbose(verbose);
        me.setConfig(config);
        me.setFunctions();
        if (inm != null) {
            Molecule[] mols = MolEvaluator.readMols(inm);
            me.setMols(mols);
        }
        StaticContext staticContext = me.getStaticContext();
        ChemExpression expression = null;
        expression = type.equals("condition") ? new MolConditionExpression(staticContext) : (type.equals("atomset") ? new AtomSetExpression(staticContext) : (type.equals("multiple") ? new MultipleExpression(staticContext) : new GeneralExpression(staticContext)));
        expression.compile(expr);
        if (ini == null) {
            Object result = expression.evaluate();
            os.println(result);
        } else {
            DynamicContext dynamicContext = new DynamicContext();
            expression.setDynamicContext(dynamicContext);
            for (int i = 0; i < ini.length; ++i) {
                MolImporter molimp = new MolImporter(ini[i]);
                RgMolecule target = new RgMolecule();
                while (molimp.read(target)) {
                    dynamicContext.setInputMolecule(target);
                    Object result = expression.evaluate();
                    if (onlyRESULT) {
                        os.println(result);
                        os.println();
                        continue;
                    }
                    String resultStr = result == null ? "null" : result.toString();
                    target.setProperty(tag, resultStr);
                    os.print(target.toFormat("sdf"));
                }
            }
        }
        if (pOs != null) {
            os.flush();
            os.close();
        }
    }
}

