/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.expression.AtomSetExpression;
import chemaxon.util.expression.ChemExpression;
import chemaxon.util.expression.DynamicContext;
import chemaxon.util.expression.GeneralExpression;
import chemaxon.util.expression.MolConditionExpression;
import chemaxon.util.expression.StaticContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MultipleExpression
extends ChemExpression {
    private ChemExpression[] expressions = null;
    private boolean success = true;

    public MultipleExpression() {
    }

    public MultipleExpression(StaticContext staticContext) {
        super(staticContext);
    }

    @Override
    public String getResultType() {
        return "HashMap";
    }

    public void compile(Element root) throws ParseException {
        this.expressions = this.createExpressions(root);
    }

    @Override
    public void compile(String expression) throws ParseException {
        this.expressions = this.createExpressions(expression);
    }

    @Override
    public Object evaluate() throws ParseException {
        this.initEvaluation();
        this.success = true;
        if (this.dynamicContext == null) {
            this.dynamicContext = new DynamicContext();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < this.expressions.length; ++i) {
            ChemExpression expression = this.expressions[i];
            expression.setDynamicContext(this.dynamicContext);
            String id = expression.getID();
            if (expression instanceof MolConditionExpression) {
                if (expression.evaluate_boolean()) {
                    if (id == null) continue;
                    result.put(id, Boolean.TRUE);
                    this.dynamicContext.addVariable(id, Boolean.TRUE);
                    continue;
                }
                if (id != null) {
                    result.put(id, Boolean.FALSE);
                    this.dynamicContext.addVariable(id, Boolean.FALSE);
                }
                this.success = false;
                break;
            }
            Object obj = expression.evaluate();
            if (id == null) continue;
            result.put(id, obj);
            this.dynamicContext.addVariable(id, obj);
        }
        return result;
    }

    @Override
    public boolean evaluate_boolean() throws ParseException {
        this.evaluate();
        return this.success;
    }

    private ChemExpression[] createExpressions(String expr) throws ParseException {
        Element root = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(expr.getBytes());
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)is);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new ParseException("DocumentException thrown while parsing " + expr + " : " + e.getMessage());
        }
        return this.createExpressions(root);
    }

    private ChemExpression[] createExpressions(Element root) throws ParseException {
        ArrayList<ChemExpression> v = new ArrayList<ChemExpression>();
        List nodes = root.selectNodes("*");
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodes.get(i);
            String name = element.getName();
            if (!name.equals("Multiple") && !name.equals("MolCondition") && !name.equals("AtomSet") && !name.equals("General") && !name.equals("Expression")) continue;
            v.add(this.createExpression(element));
        }
        ChemExpression[] result = new ChemExpression[v.size()];
        v.toArray(result);
        return result;
    }

    private ChemExpression createExpression(Element element) throws ParseException {
        ChemExpression expression = null;
        String id = element.attributeValue("ID", "");
        String name = element.getName();
        if (name.equals("Multiple")) {
            expression = new MultipleExpression(this.staticContext);
            ((MultipleExpression)expression).compile(element);
        } else {
            String text = element.getText();
            if (text == null) {
                throw new ParseException("Expression node: " + element + " does not have a single text node or CDATA child.");
            }
            if (name.equals("MolCondition")) {
                expression = new MolConditionExpression(this.staticContext);
            } else if (name.equals("AtomSet")) {
                expression = new AtomSetExpression(this.staticContext);
            } else if (name.equals("General")) {
                expression = new GeneralExpression(this.staticContext);
                String type = element.attributeValue("type");
                if (type.length() > 0) {
                    ((GeneralExpression)expression).setResultType(type);
                }
            } else {
                throw new ParseException("Unknown expression type: " + name);
            }
            expression.compile(text);
        }
        if (id.length() > 0) {
            expression.setID(id);
        }
        expression.setTop(false);
        return expression;
    }
}

