/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.struc.Molecule;
import chemaxon.util.SearchAttributes;
import chemaxon.util.expression.function.MajorMsFunction;
import chemaxon.util.expression.function.Plugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class StaticContext {
    private PluginNameSorter pluginNameSorter = new PluginNameSorter();
    private String[] sortedPluginNames = null;
    private HashSet pluginNames = new HashSet();
    private HashSet constantNames = new HashSet();
    private HashSet constants = new HashSet();
    private Hashtable variables = new Hashtable();
    private Hashtable functions = new Hashtable();
    private SearchAttributes attributes = null;
    private Plugin pl = new Plugin();
    private boolean verbose;

    public StaticContext() {
        this.addFunction("PLUGIN", this.pl);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Object getVariable(String id) {
        return this.variables.get(id);
    }

    protected Hashtable getVariables() {
        return this.variables;
    }

    protected Hashtable getFunctions() {
        return this.functions;
    }

    public void addFunction(String name, PostfixMathCommandI function) {
        this.functions.put(name, function);
    }

    protected void addPlugin(String name, CalculatorPlugin plugin) {
        this.variables.put(name, plugin);
        this.pluginNames.add(name);
        this.sortedPluginNames = null;
    }

    protected void addConstant(String name, Object constant) {
        this.variables.put(name, constant);
        this.constantNames.add(name);
        this.constants.add(constant);
    }

    public boolean isConstant(Object o) {
        return this.constants.contains(o);
    }

    protected boolean isConstantName(String name) {
        return this.constantNames.contains(name);
    }

    protected String[] getMajorMsFunctionNames() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration keys = this.functions.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!(this.functions.get(key) instanceof MajorMsFunction)) continue;
            list.add(key);
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    protected boolean isPluginName(String name) {
        return this.pluginNames.contains(name);
    }

    protected String[] getSortedPluginNames() {
        if (this.sortedPluginNames == null) {
            this.sortedPluginNames = new String[this.pluginNames.size()];
            this.pluginNames.toArray(this.sortedPluginNames);
            Arrays.sort(this.sortedPluginNames, this.pluginNameSorter);
        }
        return this.sortedPluginNames;
    }

    protected void initPlugins() throws ParseException {
        this.pl.init();
    }

    public void setMols(Molecule[] mols) {
        for (int i = 0; i < mols.length; ++i) {
            this.addConstant("MOL" + i, mols[i]);
        }
    }

    public void setSearchAttributes(SearchAttributes attributes) {
        this.attributes = attributes;
    }

    public SearchAttributes getSearchAttributes() {
        return this.attributes;
    }

    static class PluginNameSorter
    implements Comparator {
        PluginNameSorter() {
        }

        public int compare(Object o1, Object o2) {
            return ((String)o2).length() - ((String)o1).length();
        }
    }
}

