/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.marvin.calculations.MajorMicrospeciesPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.util.expression.function.ChemFunction;
import java.util.Properties;

public class MajorMsFunction
extends ChemFunction {
    private MajorMicrospeciesPlugin msplugin = null;
    private double origpH = Double.NaN;
    private double currentpH;
    private double cachedpH;
    private Molecule cachedMol = null;
    private Molecule cachedMajorMs = null;

    public MajorMsFunction() {
        super(-1);
    }

    @Override
    public void setParameters(Properties params) throws ParseException {
        String pHstr = params.getProperty("pH");
        if (pHstr != null) {
            try {
                this.setOriginalpH(Double.parseDouble(pHstr));
            }
            catch (NumberFormatException e) {
                throw new ParseException("pH should be a real number: " + pHstr);
            }
        }
    }

    public void setOriginalpH(double pH) {
        this.origpH = pH;
        this.setpH(pH);
    }

    public void setpH(double pH) {
        this.currentpH = pH;
        if (Double.isNaN(pH)) {
            this.msplugin = null;
        } else {
            if (this.msplugin == null) {
                this.msplugin = new MajorMicrospeciesPlugin();
            }
            this.msplugin.setpH(pH);
        }
    }

    public double getOriginalpH() {
        return this.origpH;
    }

    public Molecule calcMajorMs(Molecule mol) throws PluginException {
        if (this.msplugin == null) {
            return mol;
        }
        if (this.cachedMajorMs != null && mol == this.cachedMol && this.currentpH == this.cachedpH) {
            return this.cachedMajorMs;
        }
        this.msplugin.setMolecule(mol);
        this.msplugin.run();
        this.cachedMol = mol;
        this.cachedpH = this.msplugin.getpH();
        this.cachedMajorMs = this.msplugin.getMajorMicrospecies();
        return this.cachedMajorMs;
    }

    public int getAtomIndex(int index) {
        return this.msplugin == null ? index : this.msplugin.getAtomIndex(index);
    }
}

