/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import java.util.Stack;

public class MinMax
extends PostfixMathCommand {
    private double sign = 0.0;

    public MinMax(double sign) {
        this.sign = sign;
        this.numberOfParameters = -1;
        this.curNumberOfParameters = -1;
    }

    @Override
    public void run(Stack s) throws ParseException {
        double res = Double.NaN;
        for (int k = 0; k < this.curNumberOfParameters; ++k) {
            double x;
            int i;
            Object p = s.pop();
            if (p instanceof Number) {
                double x2 = ((Number)p).doubleValue() * this.sign;
                if (res > x2) continue;
                res = x2;
                continue;
            }
            if (p instanceof double[]) {
                double[] a = (double[])p;
                for (i = 0; i < a.length; ++i) {
                    x = a[i] * this.sign;
                    if (res > x) continue;
                    res = x;
                }
                continue;
            }
            if (p instanceof int[]) {
                int[] a = (int[])p;
                for (i = 0; i < a.length; ++i) {
                    x = (double)a[i] * this.sign;
                    if (res > x) continue;
                    res = x;
                }
                continue;
            }
            if (!(p instanceof long[])) continue;
            long[] a = (long[])p;
            for (i = 0; i < a.length; ++i) {
                x = (double)a[i] * this.sign;
                if (res > x) continue;
                res = x;
            }
        }
        s.push(new Double(res *= this.sign));
    }
}

