/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.marvin.calculations.MajorMicrospeciesPlugin;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.util.expression.function.ChemFunction;
import java.util.Hashtable;
import java.util.Stack;

public class Plugin
extends ChemFunction {
    private Hashtable moltab = new Hashtable();

    public Plugin() {
        super(-1);
    }

    public void init() {
        this.moltab.clear();
    }

    @Override
    public void run(Stack s) throws ParseException {
        CalculatorPlugin plugin = null;
        Molecule imol = this.getInputMolecule();
        int index = 0;
        String type = null;
        double pH = Double.NaN;
        for (int i = 0; i < this.curNumberOfParameters; ++i) {
            Object p = s.pop();
            if (p instanceof CalculatorPlugin) {
                plugin = (CalculatorPlugin)p;
                continue;
            }
            if (p instanceof Molecule) {
                imol = (Molecule)p;
                continue;
            }
            if (p instanceof Number) {
                index = ((Number)p).intValue();
                continue;
            }
            if (p instanceof String) {
                String str = (String)p;
                try {
                    pH = Double.parseDouble(str);
                }
                catch (NumberFormatException e) {
                    pH = Double.NaN;
                    type = str;
                }
                continue;
            }
            throw new ParseException("invalid plugin parameter type: " + p + " - " + p.getClass());
        }
        if (plugin == null) {
            throw new ParseException("no plugin given");
        }
        try {
            Object result = this.getPluginResult(plugin, imol, pH, type, index);
            s.push(result);
        }
        catch (PluginException e) {
            throw new ParseException(e);
        }
    }

    public Object getPluginResult(CalculatorPlugin plugin, Molecule imol, double pH, String type, int index) throws PluginException {
        boolean runit = this.moltab.get(plugin) != imol || !this.isConstant(imol) && this.getInputMolecule() != imol || plugin instanceof MajorMicrospeciesPlugin;
        return this.getPluginResult(plugin, imol, pH, type, index, runit);
    }

    private Object getPluginResult(CalculatorPlugin plugin, Molecule imol, double pH, String type, int index, boolean runit) throws PluginException {
        double origpH = Double.NaN;
        if (runit) {
            try {
                if (plugin instanceof MajorMicrospeciesPlugin) {
                    origpH = ((MajorMicrospeciesPlugin)plugin).getpH();
                    if (!Double.isNaN(pH) || Double.isNaN(origpH)) {
                        ((MajorMicrospeciesPlugin)plugin).setpH(pH);
                    }
                }
                plugin.checkMolecule(imol);
                this.moltab.put(plugin, imol);
                plugin.setMolecule(imol);
                boolean ok = plugin.run();
                if (!ok && this.isVerbose()) {
                    System.err.println("Calculation warning for molecule " + imol.toFormat("smiles") + ": " + plugin.getErrorMessage());
                    System.err.println();
                }
            }
            catch (PluginException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PluginException(e);
            }
        }
        try {
            Object result;
            Object object = result = type == null ? plugin.getResult(index) : plugin.getResult((Object)type, index);
            return object;
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
        finally {
            if (plugin instanceof MajorMicrospeciesPlugin) {
                ((MajorMicrospeciesPlugin)plugin).setpH(origpH);
            }
        }
    }
}

