/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.util.expression.function.SearchFunction;
import java.util.Stack;

public class Search
extends SearchFunction {
    @Override
    public void run(Stack s) throws ParseException {
        if (this.curNumberOfParameters <= 0 || this.curNumberOfParameters > 2) {
            throw new ParseException("illegal number of parameters: " + this.curNumberOfParameters);
        }
        Object p = s.pop();
        if (p instanceof Number) {
            int m = ((Number)p).intValue();
            int result = this.getSearchMap().map(m);
            s.push(new Integer(result));
        } else {
            if (!(p instanceof Molecule)) {
                throw new ParseException("illegal parameter type: " + p + " - " + p.getClass());
            }
            Molecule query = (Molecule)p;
            Molecule target = null;
            if (this.curNumberOfParameters == 2) {
                p = s.pop();
                if (!(p instanceof Molecule)) {
                    throw new ParseException("illegal parameter type: " + p + " - " + p.getClass());
                }
                target = (Molecule)p;
            } else {
                target = this.getInputMolecule();
            }
            try {
                int[] hit = this.findFirst(target, query);
                s.push(hit != null ? TRUE : FALSE);
            }
            catch (SearchException e) {
                throw new ParseException(e);
            }
        }
    }
}

