/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class SearchMap
extends PostfixMathCommand {
    private static final int MAXMAPS = 1024;
    private int[] map2Q = new int[1024];
    private int[] hit = null;
    private int[][] hits = null;
    private ArrayList[] inhits = null;

    public SearchMap() {
        this.numberOfParameters = 1;
        this.curNumberOfParameters = 1;
        Arrays.fill(this.map2Q, -1);
    }

    public void setQuery(Molecule query) {
        Arrays.fill(this.map2Q, -1);
        for (int i = query.getAtomCount() - 1; i >= 0; --i) {
            int m = query.getAtom(i).getAtomMap();
            if (m <= 0) continue;
            this.map2Q[m] = i;
        }
    }

    public void setHit(int[] hit) {
        this.hit = hit;
    }

    public void setHits(int[][] hits) {
        int j;
        int i;
        this.hits = hits;
        if (hits == null) {
            this.inhits = null;
            return;
        }
        int max = 0;
        for (i = 0; i < hits.length; ++i) {
            for (j = 0; j < hits[i].length; ++j) {
                max = Math.max(hits[i][j], max);
            }
        }
        if (this.inhits == null || ++max > this.inhits.length) {
            this.inhits = new ArrayList[max];
        } else {
            for (i = 0; i < this.inhits.length; ++i) {
                if (this.inhits[i] == null) continue;
                this.inhits[i].clear();
            }
        }
        for (i = 0; i < hits.length; ++i) {
            for (j = 0; j < hits[i].length; ++j) {
                int tind = hits[i][j];
                if (tind < 0) continue;
                if (this.inhits[tind] == null) {
                    this.inhits[tind] = new ArrayList();
                }
                this.inhits[tind].add(new int[]{i, j});
            }
        }
    }

    public int map(int m) throws ParseException {
        int index = this.map2Q[m];
        if (index == -1) {
            throw new ParseException("map does not exist in query: " + m);
        }
        return this.hit[index];
    }

    public boolean contains(int index) {
        block7: {
            block6: {
                if (this.hits == null) break block6;
                if (index >= 0) {
                    if (index < this.inhits.length) {
                        return this.inhits[index] != null && !this.inhits[index].isEmpty();
                    }
                } else {
                    for (int i = 0; i < this.hits.length; ++i) {
                        for (int j = 0; j < this.hits[i].length; ++j) {
                            if (this.hits[i][j] != index) continue;
                            return true;
                        }
                    }
                }
                break block7;
            }
            if (this.hit == null) break block7;
            for (int i = 0; i < this.hit.length; ++i) {
                if (this.hit[i] != index) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(int index, int m) {
        int qmindex = this.map2Q[m];
        if (this.hits != null) {
            if (index >= 0) {
                if (index >= this.inhits.length || this.inhits[index] == null) {
                    return false;
                }
                ArrayList v = this.inhits[index];
                for (int i = v.size() - 1; i >= 0; --i) {
                    if (((int[])v.get(i))[1] != qmindex) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < this.hits.length; ++i) {
                    if (this.hits[i][qmindex] != index) continue;
                    return true;
                }
            }
        } else if (this.hit != null) {
            return this.hit[qmindex] == index;
        }
        return false;
    }

    public boolean contains(int index, int[] maps) {
        block9: {
            block8: {
                if (this.hits == null) break block8;
                if (index >= 0) {
                    if (index >= this.inhits.length || this.inhits[index] == null) {
                        return false;
                    }
                    ArrayList v = this.inhits[index];
                    for (int i = v.size() - 1; i >= 0; --i) {
                        int qind = ((int[])v.get(i))[1];
                        for (int j = 0; j < maps.length; ++j) {
                            int qmindex = this.map2Q[maps[j]];
                            if (qind != qmindex) continue;
                            return true;
                        }
                    }
                } else {
                    for (int i = 0; i < this.hits.length; ++i) {
                        for (int j = 0; j < maps.length; ++j) {
                            int qmindex = this.map2Q[maps[j]];
                            if (this.hits[i][qmindex] != index) continue;
                            return true;
                        }
                    }
                }
                break block9;
            }
            if (this.hit == null) break block9;
            for (int j = 0; j < maps.length; ++j) {
                int qmindex = this.map2Q[maps[j]];
                if (this.hit[qmindex] != index) continue;
                return true;
            }
        }
        return false;
    }

    public int[] hitContaining(int index) {
        block6: {
            block5: {
                if (this.hits == null) break block5;
                if (index >= 0) {
                    if (index >= this.inhits.length || this.inhits[index] == null || this.inhits[index].isEmpty()) {
                        return null;
                    }
                    ArrayList v = this.inhits[index];
                    int hitind = ((int[])v.get(0))[0];
                    return this.hits[hitind];
                }
                for (int i = 0; i < this.hits.length; ++i) {
                    for (int j = 0; j < this.hits[i].length; ++j) {
                        if (this.hits[i][j] != index) continue;
                        return this.hits[i];
                    }
                }
                break block6;
            }
            if (this.hit == null) break block6;
            for (int i = 0; i < this.hit.length; ++i) {
                if (this.hit[i] != index) continue;
                return this.hit;
            }
        }
        return null;
    }

    public int[] hitContaining(int index, int m) {
        int qmindex = this.map2Q[m];
        if (this.hits != null) {
            if (index >= 0) {
                if (index >= this.inhits.length || this.inhits[index] == null || this.inhits[index].isEmpty()) {
                    return null;
                }
                ArrayList v = this.inhits[index];
                for (int i = v.size() - 1; i >= 0; --i) {
                    int[] inds = (int[])v.get(i);
                    if (inds[1] != qmindex) continue;
                    return this.hits[inds[0]];
                }
            } else {
                for (int i = 0; i < this.hits.length; ++i) {
                    if (this.hits[i][qmindex] != index) continue;
                    return this.hits[i];
                }
            }
        } else if (this.hit != null && this.hit[qmindex] == index) {
            return this.hit;
        }
        return null;
    }

    public int[] hitContaining(int index, int[] maps) {
        block9: {
            block8: {
                if (this.hits == null) break block8;
                if (index >= 0) {
                    if (index >= this.inhits.length || this.inhits[index] == null) {
                        return null;
                    }
                    ArrayList v = this.inhits[index];
                    for (int i = v.size() - 1; i >= 0; --i) {
                        int[] inds = (int[])v.get(i);
                        for (int j = 0; j < maps.length; ++j) {
                            int qmindex = this.map2Q[maps[j]];
                            if (inds[1] != qmindex) continue;
                            return this.hits[inds[0]];
                        }
                    }
                } else {
                    for (int i = 0; i < this.hits.length; ++i) {
                        for (int j = 0; j < maps.length; ++j) {
                            int qmindex = this.map2Q[maps[j]];
                            if (this.hits[i][qmindex] != index) continue;
                            return this.hits[i];
                        }
                    }
                }
                break block9;
            }
            if (this.hit == null) break block9;
            for (int j = 0; j < maps.length; ++j) {
                int qmindex = this.map2Q[maps[j]];
                if (this.hit[qmindex] != index) continue;
                return this.hit;
            }
        }
        return null;
    }

    public int[][] hitsContaining(int index) {
        if (this.hits != null) {
            ArrayList<int[]> result = null;
            if (index >= 0) {
                if (index >= this.inhits.length || this.inhits[index] == null || this.inhits[index].isEmpty()) {
                    return null;
                }
                ArrayList v = this.inhits[index];
                result = new ArrayList(v.size());
                for (int i = v.size() - 1; i >= 0; --i) {
                    int hitind = ((int[])v.get(i))[0];
                    result.add(this.hits[hitind]);
                }
            } else {
                result = new ArrayList<int[]>(this.hits.length);
                block1: for (int i = 0; i < this.hits.length; ++i) {
                    for (int j = 0; j < this.hits[i].length; ++j) {
                        if (this.hits[i][j] != index) continue;
                        result.add(this.hits[i]);
                        continue block1;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            int[][] res = new int[result.size()][];
            result.toArray((T[])res);
            return res;
        }
        if (this.hit != null) {
            for (int i = 0; i < this.hit.length; ++i) {
                if (this.hit[i] != index) continue;
                return new int[][]{this.hit};
            }
        }
        return null;
    }

    public int[][] hitsContaining(int index, int m) {
        int qmindex = this.map2Q[m];
        if (this.hits != null) {
            ArrayList<int[]> result = null;
            if (index >= 0) {
                if (index >= this.inhits.length || this.inhits[index] == null || this.inhits[index].isEmpty()) {
                    return null;
                }
                ArrayList v = this.inhits[index];
                result = new ArrayList(v.size());
                for (int i = this.inhits[index].size() - 1; i >= 0; --i) {
                    int[] inds = (int[])v.get(i);
                    if (inds[1] != qmindex) continue;
                    result.add(this.hits[inds[0]]);
                }
            } else {
                result = new ArrayList<int[]>(this.hits.length);
                for (int i = 0; i < this.hit.length; ++i) {
                    if (this.hits[i][qmindex] != index) continue;
                    result.add(this.hits[i]);
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            int[][] res = new int[result.size()][];
            result.toArray((T[])res);
            return res;
        }
        if (this.hit != null) {
            for (int i = 0; i < this.hit.length; ++i) {
                if (this.hit[qmindex] != index) continue;
                return new int[][]{this.hit};
            }
        }
        return null;
    }

    public int[][] hitsContaining(int index, int[] maps) {
        if (this.hits != null) {
            ArrayList<int[]> result = null;
            if (index >= 0) {
                if (index >= this.inhits.length || this.inhits[index] == null || this.inhits[index].isEmpty()) {
                    return null;
                }
                ArrayList v = this.inhits[index];
                result = new ArrayList(v.size());
                block0: for (int i = this.inhits[index].size() - 1; i >= 0; --i) {
                    int[] inds = (int[])v.get(i);
                    for (int j = 0; j < maps.length; ++j) {
                        int qmindex = this.map2Q[maps[j]];
                        if (inds[1] != qmindex) continue;
                        result.add(this.hits[inds[0]]);
                        continue block0;
                    }
                }
            } else {
                result = new ArrayList<int[]>(this.hits.length);
                block2: for (int i = 0; i < this.hit.length; ++i) {
                    for (int j = 0; j < maps.length; ++j) {
                        int qmindex = this.map2Q[maps[j]];
                        if (this.hits[i][qmindex] != index) continue;
                        result.add(this.hits[i]);
                        continue block2;
                    }
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            int[][] res = new int[result.size()][];
            result.toArray((T[])res);
            return res;
        }
        if (this.hit != null) {
            for (int i = 0; i < this.hit.length; ++i) {
                for (int j = 0; j < maps.length; ++j) {
                    int qmindex = this.map2Q[maps[j]];
                    if (this.hit[qmindex] != index) continue;
                    return new int[][]{this.hit};
                }
            }
        }
        return null;
    }

    @Override
    public void run(Stack s) throws ParseException {
        Object p = s.pop();
        if (!(p instanceof Number)) {
            throw new ParseException("Parameter is not a number: " + p);
        }
        int m = ((Number)p).intValue();
        int result = this.map(m);
        s.push(new Integer(result));
    }
}

