/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.hitfinder;

import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.util.BlockingIntArrayQueue;
import chemaxon.util.concurrent.util.Timeout;
import chemaxon.util.concurrent.worker.Worker;
import chemaxon.util.concurrent.worker.WorkerController;
import chemaxon.util.concurrent.worker.WorkerFactory;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import chemaxon.util.hitfinder.HitFinderFactory;
import chemaxon.util.hitfinder.HitFinderInput;
import chemaxon.util.hitfinder.HitFinderInputProducer;
import chemaxon.util.hitfinder.HitFinderWorker;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class HitFinderController<I>
extends WorkerController<Object, Object> {
    private BlockingIntArrayQueue hitArray = new BlockingIntArrayQueue();
    private Future<Object> future;

    public HitFinderController(int threadCount, final HitFinderInputProducer<I> inputProducer, final HitFinderFactory<I> hitFinderFactory) throws IOException {
        super(threadCount, new Timeout(60000L));
        final HitFinderInputProducer l_inputProducer = new HitFinderInputProducer<I>(){

            @Override
            public synchronized HitFinderInput<I> getNextInput() throws Exception {
                return inputProducer.getNextInput();
            }
        };
        this.setWorkerFactory(new WorkerFactory<Object>(){

            @Override
            public Worker<Object> createWorker() throws Exception {
                return new HitFinderWorker(l_inputProducer, hitFinderFactory.createHitFinder(), HitFinderController.this.hitArray);
            }
        });
    }

    @Override
    public Object call() throws Exception {
        return super.call();
    }

    @Override
    protected void setError(Throwable error) {
        this.hitArray.setError(error);
        super.setError(error);
    }

    @Override
    public void cancel() {
        this.hitArray.cancel();
        super.cancel();
    }

    @Override
    protected Object getResult() {
        this.hitArray.stop();
        return null;
    }

    @Override
    protected Object processWorkerResult(Object workerResult, Object workerControllerResult) {
        return null;
    }

    public void start() {
        this.hitArray.start();
        this.future = WorkUnitManager.getInstance().submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException, ExecutionException {
        try {
            this.cancel();
        }
        finally {
            block15: {
                try {
                    this.future.get();
                }
                catch (CancellationException ce) {
                    if (this.getError() == null) {
                        this.setError(ce);
                    }
                }
                finally {
                    Throwable t = this.getError();
                    if (t == null) break block15;
                    if (t instanceof ExecutionException) {
                        throw (ExecutionException)t;
                    }
                    throw new ExecutionException(t);
                }
            }
        }
    }

    public int[] getAvailableNewHits(int resultChunkSize) throws DatabaseSearchException, InterruptedException {
        return this.hitArray.getAvailableNewHits(resultChunkSize);
    }
}

