/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.iterator;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachedMoleculeIterator
implements MoleculeIterator {
    private static final Logger logger = Logger.getLogger(CachedMoleculeIterator.class.getName());
    private static String cacheFilePrefix = "molcache";
    private MoleculeIterator it;
    private String format;
    private double reserveMemorySize = 64.0;
    private File cacheFile = null;
    private int index = 0;
    private int cacheSize = 0;
    private boolean restarted = false;
    private ArrayList<Molecule> memCache = null;
    private boolean memoryCacheAvailable = true;
    private MolExporter diskCacheWriter = null;
    private MolImporter diskCacheReader = null;
    private Runtime runtime = null;

    public CachedMoleculeIterator(MoleculeIterator it, String format2, double reserveMemorySize) {
        this.it = it;
        this.format = format2;
        this.reserveMemorySize = reserveMemorySize;
        this.index = 0;
        this.memCache = new ArrayList();
        this.runtime = Runtime.getRuntime();
    }

    public void restart() {
        this.index = 0;
        this.restarted = true;
        if (this.diskCacheReader != null) {
            try {
                this.diskCacheReader.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Cannot close importer.", e);
            }
            this.diskCacheReader = null;
        }
    }

    @Override
    public Molecule next() {
        if (!this.hasNext()) {
            return null;
        }
        Molecule next = null;
        if (!this.restarted) {
            next = this.it.next();
            if (this.isMemoryCacheAvailable()) {
                this.memCache.add(next);
            } else {
                if (this.diskCacheWriter == null) {
                    try {
                        this.cacheFile = File.createTempFile(cacheFilePrefix, null);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Temp file created:: " + this.cacheFile.getAbsolutePath());
                        }
                        this.cacheFile.deleteOnExit();
                        this.diskCacheWriter = new MolExporter(new BufferedOutputStream(new FileOutputStream(this.cacheFile)), this.format);
                    }
                    catch (MolExportException e) {
                        throw new NoSuchElementException("Export error ocurred when writing file: " + this.cacheFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new NoSuchElementException("File " + this.cacheFile.getAbsolutePath() + " cannot be created, or cannot write to file.");
                    }
                }
                try {
                    this.diskCacheWriter.write(next);
                }
                catch (MolExportException e) {
                    throw new NoSuchElementException("Export error ocurred when writing file: " + this.cacheFile.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new NoSuchElementException("Cannot write to file: " + this.cacheFile.getAbsolutePath());
                }
            }
            ++this.index;
        } else {
            if (this.index < this.memCache.size()) {
                next = this.memCache.get(this.index);
            } else {
                if (this.diskCacheReader == null) {
                    try {
                        this.diskCacheReader = new MolImporter(this.cacheFile, this.format);
                    }
                    catch (MolFormatException e) {
                        throw new NoSuchElementException("Cannot read file: " + this.cacheFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new NoSuchElementException("Cannot read file: " + this.cacheFile.getAbsolutePath());
                    }
                }
                try {
                    next = this.diskCacheReader.read();
                }
                catch (IOException e) {
                    throw new NoSuchElementException("Cannot read file: " + this.cacheFile.getAbsolutePath());
                }
            }
            ++this.index;
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean isMemoryCacheAvailable() {
        if (this.memoryCacheAvailable && this.memCache.size() % 100 == 0) {
            double totalFreeMemory = (this.runtime.freeMemory() + (this.runtime.maxMemory() - this.runtime.totalMemory())) / 0x100000L;
            if (totalFreeMemory < this.reserveMemorySize) {
                this.runtime.gc();
                totalFreeMemory = (this.runtime.freeMemory() + (this.runtime.maxMemory() - this.runtime.totalMemory())) / 0x100000L;
            }
            this.memoryCacheAvailable = totalFreeMemory > this.reserveMemorySize;
        }
        return this.memoryCacheAvailable;
    }

    @Override
    public boolean hasNext() {
        if (!this.restarted) {
            boolean hasNext = this.it.hasNext();
            if (!hasNext) {
                if (this.diskCacheWriter != null) {
                    try {
                        this.diskCacheWriter.close();
                    }
                    catch (MolExportException e) {
                        logger.log(Level.WARNING, "Export error when closing file: " + this.cacheFile.getAbsolutePath(), e);
                        return false;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Cannot close file: " + this.cacheFile.getAbsolutePath(), e);
                        return false;
                    }
                }
                this.cacheSize = this.index;
            }
            return hasNext;
        }
        return this.index < this.cacheSize;
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    @Override
    public double estimateProgress() {
        if (!this.restarted) {
            return this.it.estimateProgress();
        }
        return (double)this.index / (double)this.cacheSize;
    }

    protected void finalize() throws Throwable {
        if (this.diskCacheReader != null) {
            this.diskCacheReader.close();
        }
        if (this.diskCacheWriter != null) {
            this.diskCacheWriter.close();
        }
        if (this.cacheFile != null) {
            this.cacheFile.delete();
        }
    }
}

