/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.iterator;

import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.util.Collection;

public class MoleculeIteratorChain
implements MoleculeIterator {
    private MoleculeIterator[] iterators;
    private MoleculeIterator currentIterator;
    private int currentIteratorIndex = -1;

    public MoleculeIteratorChain(MoleculeIterator[] iterators) {
        this.iterators = iterators;
        if (iterators != null && iterators.length > 0) {
            this.currentIterator = iterators[0];
            this.currentIteratorIndex = 0;
        }
    }

    public MoleculeIteratorChain(Collection<MoleculeIterator> iterators) {
        this(iterators.toArray(new MoleculeIterator[iterators.size()]));
    }

    @Override
    public Molecule next() {
        if (this.hasNext()) {
            return this.currentIterator.next();
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIteratorIndex < 0) {
            return false;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        if (this.currentIteratorIndex < this.iterators.length - 1) {
            this.currentIterator = this.iterators[++this.currentIteratorIndex];
            return this.hasNext();
        }
        return false;
    }

    @Override
    public Throwable getThrowable() {
        return this.currentIterator != null ? this.currentIterator.getThrowable() : null;
    }

    @Override
    public double estimateProgress() {
        if (!this.hasNext()) {
            return 1.0;
        }
        return (double)this.currentIteratorIndex / (double)this.iterators.length + this.currentIterator.estimateProgress() / (double)this.iterators.length;
    }
}

