/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.iterator;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MoleculeIteratorFactory {
    public static MoleculeIterator createMoleculeIterator(Collection<Molecule> moleculeCollection) {
        return new MoleculeCollectionIterator(moleculeCollection);
    }

    public static MoleculeIterator createMoleculeIterator(Molecule[] moleculeArray) {
        return new MoleculeArrayIterator(moleculeArray);
    }

    public static MoleculeIterator getMoleculeIterator(MolImporter importer) {
        return importer.getMoleculeIterator();
    }

    public static MoleculeIterator[] getMoleculeIterators(MolImporter[] importers) {
        ArrayList<MoleculeIterator> iteratorList = new ArrayList<MoleculeIterator>();
        for (int i = 0; i < importers.length; ++i) {
            MoleculeIterator iterator = importers[i].getMoleculeIterator();
            iteratorList.add(iterator);
        }
        MoleculeIterator[] moleculeIterators = new MoleculeIterator[iteratorList.size()];
        iteratorList.toArray(moleculeIterators);
        return moleculeIterators;
    }

    private static class MoleculeArrayIterator
    implements MoleculeIterator {
        private Molecule[] molecules;
        private int index;

        MoleculeArrayIterator(Molecule[] molecules) {
            if (molecules != null && molecules.length > 0) {
                this.molecules = molecules;
                this.index = 0;
            }
        }

        @Override
        public Molecule next() {
            if (this.hasNext()) {
                return this.molecules[this.index++];
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.molecules != null ? this.index < this.molecules.length : false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double estimateProgress() {
            if (this.molecules != null && this.molecules.length > 0) {
                return this.index / this.molecules.length;
            }
            return 1.0;
        }

        @Override
        public Throwable getThrowable() {
            return null;
        }
    }

    private static class MoleculeCollectionIterator
    implements MoleculeIterator {
        private Iterator<Molecule> it;
        private int size;
        private int index;

        MoleculeCollectionIterator(Collection<Molecule> collection) {
            if (collection != null && collection.size() > 0) {
                this.it = collection.iterator();
                this.size = collection.size();
                this.index = 0;
            }
        }

        @Override
        public Molecule next() {
            if (this.hasNext()) {
                ++this.index;
                return this.it.next();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.it != null ? this.it.hasNext() : false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double estimateProgress() {
            if (this.hasNext()) {
                return (double)this.index / (double)this.size;
            }
            return 1.0;
        }

        @Override
        public Throwable getThrowable() {
            return null;
        }
    }
}

