/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.reaction;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.ModuleNotAvailableException;
import chemaxon.util.reaction.ReactionPerformer;

public class ReactionPerformerFactory {
    private static final String TRANSFORMER_CLASS_NAME = "chemaxon.reaction.Transformer";

    public static ReactionPerformer createTransformer(Molecule reaction) throws ModuleNotAvailableException {
        ReactionPerformer performer;
        try {
            performer = (ReactionPerformer)Class.forName(TRANSFORMER_CLASS_NAME).newInstance();
        }
        catch (InstantiationException e) {
            throw new ModuleNotAvailableException("JChem module is not available.", e);
        }
        catch (IllegalAccessException e) {
            throw new ModuleNotAvailableException("JChem module is not available.", e);
        }
        catch (ClassNotFoundException e) {
            throw new ModuleNotAvailableException("JChem module is not available.", e);
        }
        if (!performer.setReaction(reaction)) {
            return null;
        }
        return performer;
    }

    public static ReactionPerformer createTransformer(String reactionSmarts) throws ModuleNotAvailableException, MolFormatException {
        return ReactionPerformerFactory.createTransformer(MolImporter.importMol(reactionSmarts));
    }
}

