/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Utilities;
import com.lowagie.text.error_messages.MessageLocalization;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Jpeg
extends Image {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APP2 = 226;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};
    private byte[][] icc;

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, float f, float f2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n) {
        int n2;
        for (n2 = 0; n2 < VALID_MARKERS.length; ++n2) {
            if (n != VALID_MARKERS[n2]) continue;
            return 0;
        }
        for (n2 = 0; n2 < NOPARAM_MARKERS.length; ++n2) {
            if (n != NOPARAM_MARKERS[n2]) continue;
            return 2;
        }
        for (n2 = 0; n2 < UNSUPPORTED_MARKERS.length; ++n2) {
            if (n != UNSUPPORTED_MARKERS[n2]) continue;
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParameters() throws BadElementException, IOException {
        int n;
        int n2;
        this.type = 32;
        this.originalType = 1;
        InputStream inputStream = null;
        try {
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            if (inputStream.read() != 255 || inputStream.read() != 216) {
                throw new BadElementException(MessageLocalization.getComposedMessage("1.is.not.a.valid.jpeg.file", string));
            }
            n2 = 1;
            while (true) {
                int n3;
                int n4;
                int n5;
                if ((n5 = inputStream.read()) < 0) {
                    throw new IOException(MessageLocalization.getComposedMessage("premature.eof.while.reading.jpg"));
                }
                if (n5 != 255) continue;
                int n6 = inputStream.read();
                if (n2 != 0 && n6 == 224) {
                    n2 = 0;
                    n = Jpeg.getShort(inputStream);
                    if (n < 16) {
                        Utilities.skip(inputStream, n - 2);
                        continue;
                    }
                    byte[] byArray = new byte[JFIF_ID.length];
                    int n7 = inputStream.read(byArray);
                    if (n7 != byArray.length) {
                        throw new BadElementException(MessageLocalization.getComposedMessage("1.corrupted.jfif.marker", string));
                    }
                    n4 = 1;
                    for (n3 = 0; n3 < byArray.length; ++n3) {
                        if (byArray[n3] == JFIF_ID[n3]) continue;
                        n4 = 0;
                        break;
                    }
                    if (n4 == 0) {
                        Utilities.skip(inputStream, n - 2 - byArray.length);
                        continue;
                    }
                    Utilities.skip(inputStream, 2);
                    n3 = inputStream.read();
                    int n8 = Jpeg.getShort(inputStream);
                    int n9 = Jpeg.getShort(inputStream);
                    if (n3 == 1) {
                        this.dpiX = n8;
                        this.dpiY = n9;
                    } else if (n3 == 2) {
                        this.dpiX = (int)((float)n8 * 2.54f + 0.5f);
                        this.dpiY = (int)((float)n9 * 2.54f + 0.5f);
                    }
                    Utilities.skip(inputStream, n - 2 - byArray.length - 7);
                    continue;
                }
                if (n6 == 238) {
                    String string2;
                    n = Jpeg.getShort(inputStream) - 2;
                    byte[] byArray = new byte[n];
                    for (int i = 0; i < n; ++i) {
                        byArray[i] = (byte)inputStream.read();
                    }
                    if (byArray.length < 12 || !(string2 = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) continue;
                    this.invert = true;
                    continue;
                }
                if (n6 == 226) {
                    String string3;
                    n = Jpeg.getShort(inputStream) - 2;
                    byte[] byArray = new byte[n];
                    for (int i = 0; i < n; ++i) {
                        byArray[i] = (byte)inputStream.read();
                    }
                    if (byArray.length < 14 || !(string3 = new String(byArray, 0, 11, "ISO-8859-1")).equals("ICC_PROFILE")) continue;
                    n4 = byArray[12] & 0xFF;
                    n3 = byArray[13] & 0xFF;
                    if (n4 < 1) {
                        n4 = 1;
                    }
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    if (this.icc == null) {
                        this.icc = new byte[n3][];
                    }
                    this.icc[n4 - 1] = byArray;
                    continue;
                }
                n2 = 0;
                int n10 = Jpeg.marker(n6);
                if (n10 == 0) {
                    Utilities.skip(inputStream, 2);
                    if (inputStream.read() != 8) {
                        throw new BadElementException(MessageLocalization.getComposedMessage("1.must.have.8.bits.per.component", string));
                    }
                    this.scaledHeight = Jpeg.getShort(inputStream);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = Jpeg.getShort(inputStream);
                    this.setRight(this.scaledWidth);
                    this.colorspace = inputStream.read();
                    this.bpc = 8;
                    break;
                }
                if (n10 == 1) {
                    throw new BadElementException(MessageLocalization.getComposedMessage("1.unsupported.jpeg.marker.2", string, String.valueOf(n6)));
                }
                if (n10 == 2) continue;
                Utilities.skip(inputStream, Jpeg.getShort(inputStream) - 2);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.plainWidth = this.getWidth();
        this.plainHeight = this.getHeight();
        if (this.icc != null) {
            int n11 = 0;
            for (n2 = 0; n2 < this.icc.length; ++n2) {
                if (this.icc[n2] == null) {
                    this.icc = null;
                    return;
                }
                n11 += this.icc[n2].length - 14;
            }
            byte[] byArray = new byte[n11];
            n11 = 0;
            for (n = 0; n < this.icc.length; ++n) {
                System.arraycopy(this.icc[n], 14, byArray, n11, this.icc[n].length - 14);
                n11 += this.icc[n].length - 14;
            }
            try {
                ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray);
                this.tagICC(iCC_Profile);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.icc = null;
        }
    }
}

