/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;

public class TextField
extends BaseField {
    private String defaultText;
    private String[] choices;
    private String[] choiceExports;
    private ArrayList choiceSelections = new ArrayList();
    private int topFirst;
    private float extraMarginLeft;
    private float extraMarginTop;
    private ArrayList substitutionFonts;
    private BaseFont extensionFont;

    public TextField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    private static boolean checkRTL(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '\u0590' || c >= '\u0780') continue;
            return true;
        }
        return false;
    }

    private static void changeFontSize(Phrase phrase, float f) {
        for (int i = 0; i < phrase.size(); ++i) {
            ((Chunk)phrase.get(i)).getFont().setSize(f);
        }
    }

    private Phrase composePhrase(String string, BaseFont baseFont, Color color, float f) {
        Phrase phrase = null;
        if (this.extensionFont == null && (this.substitutionFonts == null || this.substitutionFonts.isEmpty())) {
            phrase = new Phrase(new Chunk(string, new Font(baseFont, f, 0, color)));
        } else {
            FontSelector fontSelector = new FontSelector();
            fontSelector.addFont(new Font(baseFont, f, 0, color));
            if (this.extensionFont != null) {
                fontSelector.addFont(new Font(this.extensionFont, f, 0, color));
            }
            if (this.substitutionFonts != null) {
                for (int i = 0; i < this.substitutionFonts.size(); ++i) {
                    fontSelector.addFont(new Font((BaseFont)this.substitutionFonts.get(i), f, 0, color));
                }
            }
            phrase = fontSelector.process(string);
        }
        return phrase;
    }

    public static String removeCRLF(String string) {
        if (string.indexOf(10) >= 0 || string.indexOf(13) >= 0) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '\n') {
                    stringBuffer.append(' ');
                    continue;
                }
                if (c == '\r') {
                    stringBuffer.append(' ');
                    if (i >= cArray.length - 1 || cArray[i + 1] != '\n') continue;
                    ++i;
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String obfuscatePassword(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = 42;
        }
        return new String(cArray);
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f = this.box.getHeight() - this.borderWidth * 2.0f - this.extraMarginTop;
        float f2 = this.borderWidth;
        if (bl) {
            f -= this.borderWidth * 2.0f;
            f2 *= 2.0f;
        }
        float f3 = Math.max(f2, 1.0f);
        float f4 = Math.min(f2, f3);
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f4, f4, this.box.getWidth() - 2.0f * f4, this.box.getHeight() - 2.0f * f4);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        String string = (this.options & 0x2000) != 0 ? TextField.obfuscatePassword(this.text) : ((this.options & 0x1000) == 0 ? TextField.removeCRLF(this.text) : this.text);
        BaseFont baseFont = this.getRealFont();
        Color color = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        int n = TextField.checkRTL(string) ? 2 : 1;
        float f5 = this.fontSize;
        Phrase phrase = this.composePhrase(string, baseFont, color, f5);
        if ((this.options & 0x1000) != 0) {
            float f6;
            float f7 = this.box.getWidth() - 4.0f * f3 - this.extraMarginLeft;
            float f8 = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
            ColumnText columnText = new ColumnText(null);
            if (f5 == 0.0f) {
                f5 = f / f8;
                if (f5 > 4.0f) {
                    if (f5 > 12.0f) {
                        f5 = 12.0f;
                    }
                    f6 = Math.max((f5 - 4.0f) / 10.0f, 0.2f);
                    columnText.setSimpleColumn(0.0f, -f, f7, 0.0f);
                    columnText.setAlignment(this.alignment);
                    columnText.setRunDirection(n);
                    while (f5 > 4.0f) {
                        columnText.setYLine(0.0f);
                        TextField.changeFontSize(phrase, f5);
                        columnText.setText(phrase);
                        columnText.setLeading(f8 * f5);
                        int n2 = columnText.go(true);
                        if ((n2 & 2) == 0) break;
                        f5 -= f6;
                    }
                }
                if (f5 < 4.0f) {
                    f5 = 4.0f;
                }
            }
            TextField.changeFontSize(phrase, f5);
            columnText.setCanvas(pdfAppearance);
            f6 = f5 * f8;
            float f9 = f3 + f - baseFont.getFontDescriptor(8, f5);
            columnText.setSimpleColumn(this.extraMarginLeft + 2.0f * f3, -20000.0f, this.box.getWidth() - 2.0f * f3, f9 + f6);
            columnText.setLeading(f6);
            columnText.setAlignment(this.alignment);
            columnText.setRunDirection(n);
            columnText.setText(phrase);
            columnText.go();
        } else {
            float f10;
            float f11;
            if (f5 == 0.0f) {
                f11 = f / (baseFont.getFontDescriptor(7, 1.0f) - baseFont.getFontDescriptor(6, 1.0f));
                TextField.changeFontSize(phrase, 1.0f);
                f10 = ColumnText.getWidth(phrase, n, 0);
                f5 = f10 == 0.0f ? f11 : Math.min(f11, (this.box.getWidth() - this.extraMarginLeft - 4.0f * f3) / f10);
                if (f5 < 4.0f) {
                    f5 = 4.0f;
                }
            }
            TextField.changeFontSize(phrase, f5);
            f11 = f4 + (this.box.getHeight() - 2.0f * f4 - baseFont.getFontDescriptor(1, f5)) / 2.0f;
            if (f11 < f4) {
                f11 = f4;
            }
            if (f11 - f4 < -baseFont.getFontDescriptor(3, f5)) {
                f10 = -baseFont.getFontDescriptor(3, f5) + f4;
                float f12 = this.box.getHeight() - f4 - baseFont.getFontDescriptor(1, f5);
                f11 = Math.min(f10, Math.max(f11, f12));
            }
            if ((this.options & 0x1000000) != 0 && this.maxCharacterLength > 0) {
                int n3 = Math.min(this.maxCharacterLength, string.length());
                int n4 = 0;
                if (this.alignment == 2) {
                    n4 = this.maxCharacterLength - n3;
                } else if (this.alignment == 1) {
                    n4 = (this.maxCharacterLength - n3) / 2;
                }
                float f13 = (this.box.getWidth() - this.extraMarginLeft) / (float)this.maxCharacterLength;
                float f14 = f13 / 2.0f + (float)n4 * f13;
                if (this.textColor == null) {
                    pdfAppearance.setGrayFill(0.0f);
                } else {
                    pdfAppearance.setColorFill(this.textColor);
                }
                pdfAppearance.beginText();
                for (int i = 0; i < phrase.size(); ++i) {
                    Chunk chunk = (Chunk)phrase.get(i);
                    BaseFont baseFont2 = chunk.getFont().getBaseFont();
                    pdfAppearance.setFontAndSize(baseFont2, f5);
                    StringBuffer stringBuffer = chunk.append("");
                    for (int j = 0; j < stringBuffer.length(); ++j) {
                        String string2 = stringBuffer.substring(j, j + 1);
                        float f15 = baseFont2.getWidthPoint(string2, f5);
                        pdfAppearance.setTextMatrix(this.extraMarginLeft + f14 - f15 / 2.0f, f11 - this.extraMarginTop);
                        pdfAppearance.showText(string2);
                        f14 += f13;
                    }
                }
                pdfAppearance.endText();
            } else {
                switch (this.alignment) {
                    case 2: {
                        f10 = this.extraMarginLeft + this.box.getWidth() - 2.0f * f3;
                        break;
                    }
                    case 1: {
                        f10 = this.extraMarginLeft + this.box.getWidth() / 2.0f;
                        break;
                    }
                    default: {
                        f10 = this.extraMarginLeft + 2.0f * f3;
                    }
                }
                ColumnText.showTextAligned(pdfAppearance, this.alignment, phrase, f10, f11 - this.extraMarginTop, 0.0f, n, 0);
            }
        }
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    PdfAppearance getListAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        if (this.choices == null || this.choices.length == 0) {
            return pdfAppearance;
        }
        pdfAppearance.beginVariableText();
        int n = this.getTopChoice();
        BaseFont baseFont = this.getRealFont();
        float f = this.fontSize;
        if (f == 0.0f) {
            f = 12.0f;
        }
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.getHeight() - this.borderWidth * 2.0f;
        float f3 = this.borderWidth;
        if (bl) {
            f2 -= this.borderWidth * 2.0f;
            f3 *= 2.0f;
        }
        float f4 = baseFont.getFontDescriptor(8, f) - baseFont.getFontDescriptor(6, f);
        int n2 = (int)(f2 / f4) + 1;
        int n3 = 0;
        int n4 = 0;
        n3 = n;
        n4 = n3 + n2;
        if (n4 > this.choices.length) {
            n4 = this.choices.length;
        }
        this.topFirst = n3;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f3, f3, this.box.getWidth() - 2.0f * f3, this.box.getHeight() - 2.0f * f3);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        Color color = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        pdfAppearance.setColorFill(new Color(10, 36, 106));
        for (int i = 0; i < this.choiceSelections.size(); ++i) {
            int n5 = (Integer)this.choiceSelections.get(i);
            if (n5 < n3 || n5 > n4) continue;
            pdfAppearance.rectangle(f3, f3 + f2 - (float)(n5 - n3 + 1) * f4, this.box.getWidth() - 2.0f * f3, f4);
            pdfAppearance.fill();
        }
        float f5 = f3 * 2.0f;
        float f6 = f3 + f2 - baseFont.getFontDescriptor(8, f);
        int n6 = n3;
        while (n6 < n4) {
            String string = this.choices[n6];
            int n7 = TextField.checkRTL(string) ? 2 : 1;
            string = TextField.removeCRLF(string);
            GrayColor grayColor = this.choiceSelections.contains(new Integer(n6)) ? GrayColor.GRAYWHITE : color;
            Phrase phrase = this.composePhrase(string, baseFont, grayColor, f);
            ColumnText.showTextAligned(pdfAppearance, 0, phrase, f5, f6, 0.0f, n7, 0);
            ++n6;
            f6 -= f4;
        }
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        if (this.maxCharacterLength <= 0) {
            this.options &= 0xFEFFFFFF;
        }
        if ((this.options & 0x1000000) != 0) {
            this.options &= 0xFFFFEFFF;
        }
        PdfFormField pdfFormField = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        switch (this.alignment) {
            case 1: {
                pdfFormField.setQuadding(1);
                break;
            }
            case 2: {
                pdfFormField.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (!"".equals(this.text)) {
                pdfFormField.setValueAsString(this.text);
            }
            if (this.defaultText != null) {
                pdfFormField.setDefaultValueAsString(this.defaultText);
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x1000) != 0) {
                pdfFormField.setFieldFlags(4096);
            }
            if ((this.options & 0x800000) != 0) {
                pdfFormField.setFieldFlags(0x800000);
            }
            if ((this.options & 0x2000) != 0) {
                pdfFormField.setFieldFlags(8192);
            }
            if ((this.options & 0x100000) != 0) {
                pdfFormField.setFieldFlags(0x100000);
            }
            if ((this.options & 0x400000) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
            if ((this.options & 0x1000000) != 0) {
                pdfFormField.setFieldFlags(0x1000000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    private int getTopChoice() {
        if (this.choiceSelections == null || this.choiceSelections.size() == 0) {
            return 0;
        }
        Integer n = (Integer)this.choiceSelections.get(0);
        if (n == null) {
            return 0;
        }
        int n2 = 0;
        if (this.choices != null) {
            n2 = n;
            n2 = Math.min(n2, this.choices.length);
            n2 = Math.max(0, n2);
        }
        return n2;
    }

    protected PdfFormField getChoiceField(boolean bl) throws IOException, DocumentException {
        PdfAppearance pdfAppearance;
        this.options &= 0xFEFFEFFF;
        String[] stringArray = this.choices;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = this.getTopChoice();
        if (this.text == null) {
            this.text = "";
        }
        if (n >= 0) {
            this.text = stringArray[n];
        }
        PdfFormField pdfFormField = null;
        String[][] stringArray2 = null;
        if (this.choiceExports == null) {
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray, n) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, stringArray, n);
        } else {
            int n2;
            stringArray2 = new String[stringArray.length][2];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                String string = stringArray[n2];
                stringArray2[n2][1] = string;
                stringArray2[n2][0] = string;
            }
            n2 = Math.min(stringArray.length, this.choiceExports.length);
            for (int i = 0; i < n2; ++i) {
                if (this.choiceExports[i] == null) continue;
                stringArray2[i][0] = this.choiceExports[i];
            }
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray2, n) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, stringArray2, n);
        }
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (stringArray.length > 0) {
                if (stringArray2 != null) {
                    if (this.choiceSelections.size() < 2) {
                        pdfFormField.setValueAsString(stringArray2[n][0]);
                        pdfFormField.setDefaultValueAsString(stringArray2[n][0]);
                    } else {
                        this.writeMultipleValues(pdfFormField, stringArray2);
                    }
                } else if (this.choiceSelections.size() < 2) {
                    pdfFormField.setValueAsString(this.text);
                    pdfFormField.setDefaultValueAsString(this.text);
                } else {
                    this.writeMultipleValues(pdfFormField, null);
                }
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x400000) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
            if ((this.options & 0x200000) != 0) {
                pdfFormField.setFieldFlags(0x200000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (bl) {
            pdfAppearance = this.getListAppearance();
            if (this.topFirst > 0) {
                pdfFormField.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            pdfAppearance = this.getAppearance();
        }
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    private void writeMultipleValues(PdfFormField pdfFormField, String[][] stringArray) {
        PdfArray pdfArray = new PdfArray();
        PdfArray pdfArray2 = new PdfArray();
        for (int i = 0; i < this.choiceSelections.size(); ++i) {
            int n = (Integer)this.choiceSelections.get(i);
            pdfArray.add(new PdfNumber(n));
            if (stringArray != null) {
                pdfArray2.add(new PdfString(stringArray[n][0]));
                continue;
            }
            if (this.choices == null) continue;
            pdfArray2.add(new PdfString(this.choices[n]));
        }
        pdfFormField.put(PdfName.V, pdfArray2);
        pdfFormField.put(PdfName.I, pdfArray);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String string) {
        this.defaultText = string;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] stringArray) {
        this.choices = stringArray;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] stringArray) {
        this.choiceExports = stringArray;
    }

    public int getChoiceSelection() {
        return this.getTopChoice();
    }

    public ArrayList gteChoiceSelections() {
        return this.choiceSelections;
    }

    public void setChoiceSelection(int n) {
        this.choiceSelections = new ArrayList();
        this.choiceSelections.add(new Integer(n));
    }

    public void addChoiceSelection(int n) {
        if ((this.options & 0x200000) != 0) {
            this.choiceSelections.add(new Integer(n));
        }
    }

    public void setChoiceSelections(ArrayList arrayList) {
        if (arrayList != null) {
            this.choiceSelections = new ArrayList(arrayList);
            if (this.choiceSelections.size() > 1 && (this.options & 0x200000) == 0) {
                while (this.choiceSelections.size() > 1) {
                    this.choiceSelections.remove(1);
                }
            }
        } else {
            this.choiceSelections.clear();
        }
    }

    int getTopFirst() {
        return this.topFirst;
    }

    public void setExtraMargin(float f, float f2) {
        this.extraMarginLeft = f;
        this.extraMarginTop = f2;
    }

    public ArrayList getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public void setSubstitutionFonts(ArrayList arrayList) {
        this.substitutionFonts = arrayList;
    }

    public BaseFont getExtensionFont() {
        return this.extensionFont;
    }

    public void setExtensionFont(BaseFont baseFont) {
        this.extensionFont = baseFont;
    }
}

