/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.internal;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.internal.PolylineShape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

public class PolylineShapeIterator
implements PathIterator {
    protected PolylineShape poly;
    protected AffineTransform affine;
    protected int index;

    PolylineShapeIterator(PolylineShape polylineShape, AffineTransform affineTransform) {
        this.poly = polylineShape;
        this.affine = affineTransform;
    }

    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException(MessageLocalization.getComposedMessage("line.iterator.out.of.bounds"));
        }
        int n = this.index == 0 ? 0 : 1;
        dArray[0] = this.poly.x[this.index];
        dArray[1] = this.poly.y[this.index];
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, 1);
        }
        return n;
    }

    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException(MessageLocalization.getComposedMessage("line.iterator.out.of.bounds"));
        }
        int n = this.index == 0 ? 0 : 1;
        fArray[0] = this.poly.x[this.index];
        fArray[1] = this.poly.y[this.index];
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, 1);
        }
        return n;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index >= this.poly.np;
    }

    public void next() {
        ++this.index;
    }
}

