/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class AutoResizingTextArea
extends JTextArea {
    public static final int DEFAULT_MAX_ROWS = 20;
    public static final int DEFAULT_MIN_ROWS = 1;
    private int _maxRows;
    private int _minRows;
    private ResizingDocumentListener _listener;

    public AutoResizingTextArea() {
        this(1, 20);
    }

    public AutoResizingTextArea(int n) {
        this(n, 20);
    }

    public AutoResizingTextArea(int n, int n2) {
        this.setMinRows(n);
        this.setMaxRows(n2);
        this.setRows(n);
    }

    public AutoResizingTextArea(String string) {
        this();
        this.setText(string);
    }

    public AutoResizingTextArea(int n, int n2, int n3) {
        this(n, n2);
        this.setMinRows(n);
        this.setMaxRows(n2);
        this.setColumns(n3);
    }

    public AutoResizingTextArea(String string, int n, int n2, int n3) {
        this(n, n2, n3);
        this.setText(string);
    }

    public AutoResizingTextArea(Document document) {
        this();
        this.setDocument(document);
    }

    public AutoResizingTextArea(Document document, String string, int n, int n2, int n3) {
        super(document, string, n, n3);
        this.setMaxRows(n2);
        this.setMinRows(n);
    }

    public void setRows(int n) {
        int n2 = super.getRows();
        int n3 = this.clipRowCount(n);
        super.setRows(n3);
        this.numberOfRowsUpdated(n2, n3);
    }

    protected void numberOfRowsUpdated(int n, int n2) {
        Container container;
        JScrollPane jScrollPane = this.getParentScrollPane();
        if (jScrollPane != null && (container = jScrollPane.getParent()) != null && container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.revalidate();
        }
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int n) {
        this._maxRows = n;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    public int getMinRows() {
        return this._minRows;
    }

    public void setMinRows(int n) {
        this._minRows = n;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 != null && this._listener != null) {
            document2.removeDocumentListener(this._listener);
        }
        super.setDocument(document);
        if (document != null) {
            if (this._listener == null) {
                this._listener = new ResizingDocumentListener();
            }
            document.addDocumentListener(this._listener);
        }
        this.updateSize();
    }

    private int clipRowCount(int n) {
        int n2 = Math.min(this._maxRows, n);
        n2 = Math.max(this._minRows, n2);
        return n2;
    }

    private int getHeight(int n) {
        Insets insets = this.getInsets();
        return n * this.getRowHeight() + insets.top + insets.bottom;
    }

    private void updateSize() {
        JScrollPane jScrollPane = this.getParentScrollPane();
        if (jScrollPane != null && jScrollPane.getParent() instanceof JComponent) {
            JComponent jComponent = (JComponent)jScrollPane.getParent();
            jComponent.revalidate();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.getMinRows() != 0 && this.getMaxRows() != 0) {
            dimension.height = Math.max(this.getHeight(this.getMinRows()), Math.min(this.getHeight(this.getMaxRows()), dimension.height));
        }
        return dimension;
    }

    private JScrollPane getParentScrollPane() {
        Container container = this.getParent();
        if (container != null && container instanceof JViewport) {
            return (JScrollPane)container.getParent();
        }
        return null;
    }

    private class ResizingDocumentListener
    implements DocumentListener {
        private ResizingDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.updateSize();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.updateSize();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.updateSize();
        }
    }
}

