/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.TIFFFaxDecoder;
import com.sun.media.jai.codecimpl.TIFFLZWDecoder;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class TIFFImage
extends SimpleRenderedImage {
    private static final boolean DEBUG = true;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    char[] bitsPerSample;
    int samplesPerPixel;
    int extraSamples;
    int compression;
    byte[] palette;
    int bands;
    char[] sampleFormat;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    boolean decodePaletteAsShorts;
    boolean isBigEndian;
    int predictor;
    int image_type;
    int dataType;
    private static final int TYPE_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TYPE_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TYPE_GREYSCALE_WHITE_IS_ZERO = 2;
    private static final int TYPE_GREYSCALE_BLACK_IS_ZERO = 3;
    private static final int TYPE_RGB = 4;
    private static final int TYPE_ARGB_PRE = 5;
    private static final int TYPE_ARGB = 6;
    private static final int TYPE_ORGB = 7;
    private static final int TYPE_RGB_EXTRA = 8;
    private static final int TYPE_PALETTE = 9;
    private static final int TYPE_TRANS = 10;
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_PACKBITS = 32773;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;
    private WritableRaster tile00 = null;

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n) throws IOException {
        Object object;
        Object object2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = new TIFFDirectory(seekableStream, n);
        this.isBigEndian = tIFFDirectory.isBigEndian();
        this.minY = 0;
        this.minX = 0;
        this.width = (int)tIFFDirectory.getFieldAsLong(256);
        this.height = (int)tIFFDirectory.getFieldAsLong(257);
        int n2 = (int)tIFFDirectory.getFieldAsLong(262);
        TIFFField tIFFField = tIFFDirectory.getField(258);
        if (tIFFField == null) {
            this.bitsPerSample = new char[1];
            this.bitsPerSample[0] = '\u0001';
        } else {
            this.bitsPerSample = tIFFField.getAsChars();
        }
        int n3 = 1;
        while (n3 < this.bitsPerSample.length) {
            if (this.bitsPerSample[n3] != this.bitsPerSample[1]) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder19"));
            }
            ++n3;
        }
        TIFFField tIFFField2 = tIFFDirectory.getField(277);
        this.samplesPerPixel = tIFFField2 == null ? 1 : (int)tIFFField2.getAsLong(0);
        TIFFField tIFFField3 = tIFFDirectory.getField(338);
        this.extraSamples = tIFFField3 == null ? 0 : (int)tIFFField3.getAsLong(0);
        TIFFField tIFFField4 = tIFFDirectory.getField(339);
        if (tIFFField4 != null) {
            this.sampleFormat = tIFFField4.getAsChars();
            int n4 = 1;
            while (n4 < this.sampleFormat.length) {
                if (this.sampleFormat[n4] != this.sampleFormat[0]) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder20"));
                }
                ++n4;
            }
        } else {
            this.sampleFormat = new char[]{'\u0001'};
        }
        if (this.sampleFormat[0] == '\u0001' || this.sampleFormat[0] == '\u0004') {
            if (this.bitsPerSample[0] == '\b') {
                this.dataType = 0;
            } else if (this.bitsPerSample[0] == '\u0010') {
                this.dataType = 1;
            } else if (this.bitsPerSample[0] == ' ') {
                this.dataType = 3;
            }
        } else if (this.sampleFormat[0] == '\u0002') {
            if (this.bitsPerSample[0] == '\u0001' || this.bitsPerSample[0] == '\u0004' || this.bitsPerSample[0] == '\b') {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder21"));
            }
            if (this.bitsPerSample[0] == '\u0010') {
                this.dataType = 2;
            } else if (this.bitsPerSample[0] == ' ') {
                this.dataType = 3;
            }
        } else if (this.sampleFormat[0] == '\u0003') {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder22"));
        }
        if (tIFFDirectory.getField(322) != null) {
            this.tileWidth = (int)tIFFDirectory.getFieldAsLong(322);
            this.tileHeight = (int)tIFFDirectory.getFieldAsLong(323);
            this.tileOffsets = tIFFDirectory.getField(324).getAsLongs();
            this.tileByteCounts = tIFFDirectory.getField(325).getAsLongs();
        } else {
            this.tileWidth = this.width;
            TIFFField tIFFField5 = tIFFDirectory.getField(278);
            if (tIFFField5 == null) {
                this.tileHeight = this.height;
            } else {
                long l = tIFFField5.getAsLong(0);
                long l2 = 1L;
                this.tileHeight = l == (l2 = (l2 << 32) - 1L) ? this.height : (int)l;
            }
            object2 = tIFFDirectory.getField(273);
            if (object2 == null) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder11"));
            }
            this.tileOffsets = ((TIFFField)object2).getAsLongs();
            object = tIFFDirectory.getField(279);
            if (object == null) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder12"));
            }
            this.tileByteCounts = ((TIFFField)object).getAsLongs();
        }
        TIFFField tIFFField6 = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField6 != null ? tIFFField6.getAsInt(0) : 1;
        switch (n2) {
            case 0: {
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0001') {
                    this.image_type = 0;
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 1);
                    byte[] byArray = new byte[2];
                    byArray[0] = -1;
                    object2 = byArray;
                    byte[] byArray2 = new byte[2];
                    byArray2[0] = -1;
                    object = byArray2;
                    byte[] byArray3 = new byte[2];
                    byArray3[0] = -1;
                    byte[] byArray4 = byArray3;
                    this.colorModel = new IndexColorModel(1, 2, (byte[])object2, (byte[])object, byArray4);
                    break;
                }
                this.image_type = 2;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 4);
                    this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, false);
                    break;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, false);
                    break;
                }
                if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                throw new IllegalArgumentException(JaiI18N.getString("TIFFImageDecoder14"));
            }
            case 1: {
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0001') {
                    this.image_type = 1;
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 1);
                    byte[] byArray = new byte[2];
                    byArray[1] = -1;
                    object2 = byArray;
                    byte[] byArray5 = new byte[2];
                    byArray5[1] = -1;
                    object = byArray5;
                    byte[] byArray6 = new byte[2];
                    byArray6[1] = -1;
                    byte[] byArray7 = byArray6;
                    this.colorModel = new IndexColorModel(1, 2, (byte[])object2, (byte[])object, byArray7);
                    break;
                }
                this.image_type = 3;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 4);
                    this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, true);
                    break;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                throw new IllegalArgumentException(JaiI18N.getString("TIFFImageDecoder14"));
            }
            case 2: {
                this.bands = this.samplesPerPixel;
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                } else if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                } else {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder15"));
                }
                if (this.samplesPerPixel < 3) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder1"));
                }
                if (this.samplesPerPixel == 3) {
                    this.image_type = 4;
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                if (this.samplesPerPixel == 4) {
                    if (this.extraSamples == 0) {
                        this.image_type = 7;
                        this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, false, 1);
                        break;
                    }
                    if (this.extraSamples == 1) {
                        this.image_type = 5;
                        this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, true, 3);
                        break;
                    }
                    if (this.extraSamples != 2) break;
                    this.image_type = 6;
                    this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, false, 2);
                    break;
                }
                this.image_type = 8;
                object2 = new int[this.bands];
                int n5 = 0;
                while (n5 < this.bands) {
                    object2[n5] = n5;
                    ++n5;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = new PixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands, this.bands * this.tileWidth, (int[])object2);
                    this.colorModel = null;
                    break;
                }
                if (this.bitsPerSample[0] != '\u0010') break;
                this.sampleModel = new PixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands, this.bands * this.tileWidth, (int[])object2);
                this.colorModel = null;
                break;
            }
            case 3: {
                this.image_type = 9;
                object2 = tIFFDirectory.getField(320);
                if (object2 == null) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder2"));
                }
                this.colormap = ((TIFFField)object2).getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.bands = 3;
                    if (this.bitsPerSample[0] != '\u0004' && this.bitsPerSample[0] != '\b' && this.bitsPerSample[0] != '\u0010') {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder13"));
                    }
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.bitsPerSample[0]);
                } else if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands);
                } else if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(1, this.tileWidth, this.tileHeight, this.bands);
                } else {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder13"));
                }
                int n6 = this.colormap.length / 3;
                byte[] byArray = new byte[n6];
                byte[] byArray8 = new byte[n6];
                byte[] byArray9 = new byte[n6];
                int n7 = n6;
                int n8 = n6 * 2;
                if (this.dataType == 2) {
                    int n9 = 0;
                    while (n9 < n6) {
                        byArray[n9] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n9]);
                        byArray8[n9] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n7 + n9]);
                        byArray9[n9] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n8 + n9]);
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n6) {
                        byArray[n10] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n10] & 0xFFFF);
                        byArray8[n10] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n7 + n10] & 0xFFFF);
                        byArray9[n10] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n8 + n10] & 0xFFFF);
                        ++n10;
                    }
                }
                this.colorModel = new IndexColorModel((int)this.bitsPerSample[0], n6, byArray, byArray8, byArray9);
                break;
            }
            case 4: {
                this.image_type = 10;
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder3"));
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder4"));
            }
        }
        this.tilesX = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.tilesY = (this.height + this.tileHeight - 1) / this.tileHeight;
        this.tileSize = this.tileWidth * this.tileHeight * this.bands;
        object2 = tIFFDirectory.getField(259);
        if (object2 != null) {
            this.compression = ((TIFFField)object2).getAsInt(0);
            if (this.compression == 3) {
                TIFFField tIFFField7 = tIFFDirectory.getField(292);
                this.tiffT4Options = tIFFField7 != null ? tIFFField7.getAsLong(0) : 0L;
            }
            if (this.compression == 4) {
                TIFFField tIFFField8 = tIFFDirectory.getField(293);
                this.tiffT6Options = tIFFField8 != null ? tIFFField8.getAsLong(0) : 0L;
            }
            if (this.compression == 2 || this.compression == 3 || this.compression == 4) {
                this.decoder = new TIFFFaxDecoder(this.fillOrder, this.tileWidth, this.tileHeight);
            }
            if (this.compression == 5) {
                TIFFField tIFFField9 = tIFFDirectory.getField(317);
                if (tIFFField9 == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = tIFFField9.getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder16"));
                    }
                    if (this.predictor == 2 && this.bitsPerSample[0] != '\b') {
                        throw new RuntimeException(String.valueOf(this.bitsPerSample[0]) + JaiI18N.getString("TIFFImageDecoder17"));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(this.tileWidth, this.predictor, this.samplesPerPixel);
            }
            if (this.compression != 1 && this.compression != 32773 && this.compression != 2 && this.compression != 3 && this.compression != 4 && this.compression != 5) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder0"));
            }
        } else {
            this.compression = 1;
        }
    }

    private ComponentColorModel createAlphaComponentColorModel(int n, boolean bl, boolean bl2, int n2) {
        ComponentColorModel componentColorModel = null;
        int[][] nArray = new int[][]{{8, 8, 8, 8}, {16, 16, 16, 16}, {16, 16, 16, 16}};
        nArray[2] = new int[]{32, 32, 32, 32};
        componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray[n], bl, bl2, n2, n);
        return componentColorModel;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] decodePackbits(byte[] var1_1, int var2_2, byte[] var3_3) {
        if (var3_3 == null) {
            var3_3 = new byte[var2_2];
        }
        var4_4 = 0;
        var5_5 = 0;
lbl5:
        // 3 sources

        try {
            while (var5_5 < var2_2) {
                block7: {
                    block6: {
                        if ((var7_7 = var1_1[var4_4++]) < 0 || var7_7 > 127) break block6;
                        var8_8 = 0;
                        while (var8_8 < var7_7 + 1) {
                            var3_3[var5_5++] = var1_1[var4_4++];
                            ++var8_8;
                        }
                        ** GOTO lbl5
                    }
                    if (var7_7 > -1 || var7_7 < -127) break block7;
                    var6_6 = var1_1[var4_4++];
                    var8_8 = 0;
                    while (var8_8 < -var7_7 + 1) {
                        var3_3[var5_5++] = var6_6;
                        ++var8_8;
                    }
                    ** GOTO lbl5
                }
                ++var4_4;
            }
        }
        catch (ArrayIndexOutOfBoundsException v0) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder10"));
        }
        return var3_3;
    }

    public TIFFDirectory getPrivateIFD(long l) throws IOException {
        return new TIFFDirectory(this.stream, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Raster getTile(int n, int n2) {
        if (n == 0 && n2 == 0 && this.tile00 != null) {
            return this.tile00;
        }
        if (n < 0 || n >= this.tilesX || n2 < 0 || n2 >= this.tilesY) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFImageDecoder5"));
        }
        byte[] byArray = null;
        short[] sArray = null;
        Object var5_5 = null;
        DataBuffer dataBuffer = this.sampleModel.createDataBuffer();
        int n3 = this.sampleModel.getDataType();
        if (n3 == 0) {
            byArray = ((DataBufferByte)dataBuffer).getData();
        } else if (n3 == 1) {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        } else if (n3 == 2) {
            sArray = ((DataBufferShort)dataBuffer).getData();
        }
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, dataBuffer, new Point(this.tileXToX(n), this.tileYToY(n2)));
        long l = 0L;
        try {
            l = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[n2 * this.tilesX + n]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
        }
        int n4 = (int)this.tileByteCounts[n2 * this.tilesX + n];
        Rectangle rectangle = new Rectangle(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        int n5 = rectangle2.width * rectangle2.height * this.bands;
        byte[] byArray2 = new byte[n4];
        switch (this.image_type) {
            case 0: 
            case 1: {
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray2, 0, n4);
                        int n6 = rectangle2.width % 8 == 0 ? rectangle2.width / 8 * rectangle2.height : (rectangle2.width / 8 + 1) * rectangle2.height;
                        this.decodePackbits(byArray2, n6, byArray);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray2, 0, n4);
                        this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                    } else if (this.compression == 2) {
                        this.stream.readFully(byArray2, 0, n4);
                        this.decoder.decode1D(byArray, byArray2, rectangle2.x, rectangle2.height);
                    } else if (this.compression == 3) {
                        this.stream.readFully(byArray2, 0, n4);
                        this.decoder.decode2D(byArray, byArray2, rectangle2.x, rectangle2.height, this.tiffT4Options);
                    } else if (this.compression == 4) {
                        this.stream.readFully(byArray2, 0, n4);
                        this.decoder.decodeT6(byArray, byArray2, rectangle2.x, rectangle2.height, this.tiffT6Options);
                    } else if (this.compression == 1) {
                        this.stream.readFully(byArray, 0, n4);
                    }
                    this.stream.seek(l);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 2: 
            case 3: {
                try {
                    if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray2, 0, n4);
                            int n7 = n5 * 2;
                            byte[] byArray3 = new byte[n7];
                            this.decodePackbits(byArray2, n7, byArray3);
                            this.interpretBytesAsShorts(byArray3, sArray, n5);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            byte[] byArray4 = new byte[n5 * 2];
                            this.lzwDecoder.decode(byArray2, byArray4, rectangle2.height);
                            this.interpretBytesAsShorts(byArray4, sArray, n5);
                        } else if (this.compression == 1) {
                            this.readShorts(n4 / 2, sArray);
                        }
                        if (this.image_type == 2) {
                            if (n3 == 1) {
                                int n8 = 0;
                                while (n8 < sArray.length) {
                                    sArray[n8] = (short)(65535 - sArray[n8]);
                                    ++n8;
                                }
                            } else if (n3 == 2) {
                                int n9 = 0;
                                while (n9 < sArray.length) {
                                    sArray[n9] = ~sArray[n9];
                                    ++n9;
                                }
                            }
                        }
                    } else if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.decodePackbits(byArray2, n5, byArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                        } else if (this.compression == 1) {
                            this.stream.readFully(byArray, 0, n4);
                        }
                    } else if (this.bitsPerSample[0] == '\u0004') {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray2, 0, n4);
                            int n10 = rectangle2.width % 8 == 0 ? rectangle2.width / 2 * rectangle2.height : (rectangle2.width / 2 + 1) * rectangle2.height;
                            this.decodePackbits(byArray2, n10, byArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                        } else {
                            this.stream.readFully(byArray, 0, n4);
                        }
                    }
                    this.stream.seek(l);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 4: {
                try {
                    if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 1) {
                            this.stream.readFully(byArray, 0, n4);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(byArray2, 0, n4);
                            this.decodePackbits(byArray2, n5, byArray);
                        }
                        int n11 = 0;
                        while (n11 < n5) {
                            byte by = byArray[n11];
                            byArray[n11] = byArray[n11 + 2];
                            byArray[n11 + 2] = by;
                            n11 += 3;
                        }
                    } else if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 1) {
                            this.readShorts(n4 / 2, sArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            byte[] byArray5 = new byte[n5 * 2];
                            this.lzwDecoder.decode(byArray2, byArray5, rectangle2.height);
                            this.interpretBytesAsShorts(byArray5, sArray, n5);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(byArray2, 0, n4);
                            int n12 = n5 * 2;
                            byte[] byArray6 = new byte[n12];
                            this.decodePackbits(byArray2, n12, byArray6);
                            this.interpretBytesAsShorts(byArray6, sArray, n5);
                        }
                        int n13 = 0;
                        while (n13 < n5) {
                            short s = sArray[n13];
                            sArray[n13] = sArray[n13 + 2];
                            sArray[n13 + 2] = s;
                            n13 += 3;
                        }
                    }
                    this.stream.seek(l);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 5: 
            case 6: 
            case 7: {
                try {
                    if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 1) {
                            this.stream.readFully(byArray, 0, n4);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(byArray2, 0, n4);
                            this.decodePackbits(byArray2, n5, byArray);
                        }
                        int n14 = 0;
                        while (n14 < n5) {
                            byte by = byArray[n14];
                            byArray[n14] = byArray[n14 + 3];
                            byArray[n14 + 3] = by;
                            by = byArray[n14 + 1];
                            byArray[n14 + 1] = byArray[n14 + 2];
                            byArray[n14 + 2] = by;
                            n14 += 4;
                        }
                    } else if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 1) {
                            this.readShorts(n4 / 2, sArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            byte[] byArray7 = new byte[n5 * 2];
                            this.lzwDecoder.decode(byArray2, byArray7, rectangle2.height);
                            this.interpretBytesAsShorts(byArray7, sArray, n5);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(byArray2, 0, n4);
                            int n15 = n5 * 2;
                            byte[] byArray8 = new byte[n15];
                            this.decodePackbits(byArray2, n15, byArray8);
                            this.interpretBytesAsShorts(byArray8, sArray, n5);
                        }
                        int n16 = 0;
                        while (n16 < n5) {
                            short s = sArray[n16];
                            sArray[n16] = sArray[n16 + 3];
                            sArray[n16 + 3] = s;
                            s = sArray[n16 + 1];
                            sArray[n16 + 1] = sArray[n16 + 2];
                            sArray[n16 + 2] = s;
                            n16 += 4;
                        }
                    }
                    this.stream.seek(l);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 8: {
                try {
                    if (this.bitsPerSample[0] == '\b') {
                        if (this.compression == 1) {
                            this.stream.readFully(byArray, 0, n4);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(byArray2, 0, n4);
                            this.decodePackbits(byArray2, n5, byArray);
                        }
                    } else if (this.bitsPerSample[0] == '\u0010') {
                        if (this.compression == 1) {
                            this.readShorts(n4 / 2, sArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            byte[] byArray9 = new byte[n5 * 2];
                            this.lzwDecoder.decode(byArray2, byArray9, rectangle2.height);
                            this.interpretBytesAsShorts(byArray9, sArray, n5);
                        } else {
                            if (this.compression != 32773) throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder18"));
                            this.stream.readFully(byArray2, 0, n4);
                            int n17 = n5 * 2;
                            byte[] byArray10 = new byte[n17];
                            this.decodePackbits(byArray2, n17, byArray10);
                            this.interpretBytesAsShorts(byArray10, sArray, n5);
                        }
                    }
                    this.stream.seek(l);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
            case 9: {
                if (this.bitsPerSample[0] == '\u0010') {
                    if (this.decodePaletteAsShorts) {
                        short[] sArray2 = null;
                        int n18 = n5 / 3;
                        int n19 = n18 * 2;
                        try {
                            byte[] byArray11;
                            if (this.compression == 32773) {
                                this.stream.readFully(byArray2, 0, n4);
                                byArray11 = new byte[n19];
                                this.decodePackbits(byArray2, n19, byArray11);
                                sArray2 = new short[n18];
                                this.interpretBytesAsShorts(byArray11, sArray2, n18);
                            } else if (this.compression == 5) {
                                this.stream.readFully(byArray2, 0, n4);
                                byArray11 = new byte[n19];
                                this.lzwDecoder.decode(byArray2, byArray11, rectangle2.height);
                                sArray2 = new short[n18];
                                this.interpretBytesAsShorts(byArray11, sArray2, n18);
                            } else if (this.compression == 1) {
                                sArray2 = new short[n4 / 2];
                                this.readShorts(n4 / 2, sArray2);
                            }
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                        }
                        if (n3 == 1) {
                            int n20 = 0;
                            int n21 = this.colormap.length / 3;
                            int n22 = n21 * 2;
                            int n23 = 0;
                            while (n23 < n18) {
                                int n24 = sArray2[n23] & 0xFFFF;
                                char c = this.colormap[n24 + n22];
                                sArray[n20++] = (short)(c & 0xFFFF);
                                c = this.colormap[n24 + n21];
                                sArray[n20++] = (short)(c & 0xFFFF);
                                c = this.colormap[n24];
                                sArray[n20++] = (short)(c & 0xFFFF);
                                ++n23;
                            }
                        } else {
                            if (n3 != 2) break;
                            int n25 = 0;
                            int n26 = this.colormap.length / 3;
                            int n27 = n26 * 2;
                            int n28 = 0;
                            while (n28 < n18) {
                                int n29 = sArray2[n28] & 0xFFFF;
                                char c = this.colormap[n29 + n27];
                                sArray[n25++] = (short)c;
                                c = this.colormap[n29 + n26];
                                sArray[n25++] = (short)c;
                                c = this.colormap[n29];
                                sArray[n25++] = (short)c;
                                ++n28;
                            }
                        }
                        break;
                    }
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray2, 0, n4);
                            int n30 = n5 * 2;
                            byte[] byArray12 = new byte[n30];
                            this.decodePackbits(byArray2, n30, byArray12);
                            this.interpretBytesAsShorts(byArray12, sArray, n5);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            byte[] byArray13 = new byte[n5 * 2];
                            this.lzwDecoder.decode(byArray2, byArray13, rectangle2.height);
                            this.interpretBytesAsShorts(byArray13, sArray, n5);
                        } else if (this.compression == 1) {
                            this.readShorts(n4 / 2, sArray);
                        }
                        this.stream.seek(l);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                    }
                }
                if (this.bitsPerSample[0] == '\b') {
                    if (this.decodePaletteAsShorts) {
                        byte[] byArray14 = null;
                        int n31 = n5 / 3;
                        try {
                            if (this.compression == 32773) {
                                this.stream.readFully(byArray2, 0, n4);
                                byArray14 = new byte[n31];
                                this.decodePackbits(byArray2, n31, byArray14);
                            } else if (this.compression == 5) {
                                this.stream.readFully(byArray2, 0, n4);
                                byArray14 = new byte[n31];
                                this.lzwDecoder.decode(byArray2, byArray14, rectangle2.height);
                            } else if (this.compression == 1) {
                                byArray14 = new byte[n4];
                                this.stream.readFully(byArray14, 0, n4);
                            }
                            this.stream.seek(l);
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                        }
                        int n32 = 0;
                        int n33 = this.colormap.length / 3;
                        int n34 = n33 * 2;
                        int n35 = 0;
                        while (n35 < n31) {
                            int n36 = byArray14[n35] & 0xFF;
                            char c = this.colormap[n36 + n34];
                            sArray[n32++] = (short)(c & 0xFFFF);
                            c = this.colormap[n36 + n33];
                            sArray[n32++] = (short)(c & 0xFFFF);
                            c = this.colormap[n36];
                            sArray[n32++] = (short)(c & 0xFFFF);
                            ++n35;
                        }
                        break;
                    }
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.decodePackbits(byArray2, n5, byArray);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray2, 0, n4);
                            this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                        } else if (this.compression == 1) {
                            this.stream.readFully(byArray, 0, n4);
                        }
                        this.stream.seek(l);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                    }
                }
                if (this.bitsPerSample[0] != '\u0004') throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder7"));
                int n37 = rectangle2.width % 2 == 0 ? 0 : 1;
                int n38 = (rectangle2.width / 2 + n37) * rectangle2.height;
                if (this.decodePaletteAsShorts) {
                    int n39;
                    byte[] byArray15 = null;
                    try {
                        this.stream.readFully(byArray2, 0, n4);
                        this.stream.seek(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                    }
                    if (this.compression == 32773) {
                        byArray15 = new byte[n38];
                        this.decodePackbits(byArray2, n38, byArray15);
                    } else if (this.compression == 5) {
                        byArray15 = new byte[n38];
                        this.lzwDecoder.decode(byArray2, byArray15, rectangle2.height);
                    } else if (this.compression == 1) {
                        byArray15 = byArray2;
                    }
                    int n40 = n5 / 3;
                    byArray2 = new byte[n40];
                    int n41 = 0;
                    int n42 = 0;
                    int n43 = 0;
                    while (n43 < rectangle2.height) {
                        n39 = 0;
                        while (n39 < rectangle2.width / 2) {
                            byArray2[n42++] = (byte)((byArray15[n41] & 0xF0) >> 4);
                            byArray2[n42++] = (byte)(byArray15[n41++] & 0xF);
                            ++n39;
                        }
                        if (n37 == 1) {
                            byArray2[n42++] = (byte)((byArray15[n41++] & 0xF0) >> 4);
                        }
                        ++n43;
                    }
                    n39 = this.colormap.length / 3;
                    int n44 = n39 * 2;
                    int n45 = 0;
                    int n46 = 0;
                    while (n46 < n40) {
                        int n47 = byArray2[n46] & 0xFF;
                        char c = this.colormap[n47 + n44];
                        sArray[n45++] = (short)(c & 0xFFFF);
                        c = this.colormap[n47 + n39];
                        sArray[n45++] = (short)(c & 0xFFFF);
                        c = this.colormap[n47];
                        sArray[n45++] = (short)(c & 0xFFFF);
                        ++n46;
                    }
                    break;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray2, 0, n4);
                        this.decodePackbits(byArray2, n38, byArray);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray2, 0, n4);
                        this.lzwDecoder.decode(byArray2, byArray, rectangle2.height);
                    } else if (this.compression == 1) {
                        this.stream.readFully(byArray, 0, n4);
                    }
                    this.stream.seek(l);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
                }
            }
        }
        if (n != 0 || n2 != 0) return writableRaster;
        this.tile00 = writableRaster;
        return writableRaster;
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n) {
        if (this.isBigEndian) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = 2 * n2;
                int n4 = byArray[n3] & 0xFF;
                int n5 = byArray[n3 + 1] & 0xFF;
                sArray[n2] = (short)((n4 << 8) + n5);
                ++n2;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                int n7 = 2 * n6;
                int n8 = byArray[n7] & 0xFF;
                int n9 = byArray[n7 + 1] & 0xFF;
                sArray[n6] = (short)((n9 << 8) + n8);
                ++n6;
            }
        }
    }

    private void readShorts(int n, short[] sArray) {
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageDecoder8"));
        }
        this.interpretBytesAsShorts(byArray, sArray, n);
    }
}

