/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollectionImpl;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;

class ArgumentCollectionBuilder {
    private final Map<String, List<String>> arguments = new LinkedHashMap<String, List<String>>();
    private final List<String> unparsed = new ArrayList<String>();
    private IParsingState state = new Initial();
    private List<String> valuesForCurrentArgument;

    ArgumentCollectionBuilder() {
    }

    void unparsedOptionsFollow() {
        this.state = new UnparsedState();
    }

    boolean isExpectingUnparsedOptions() {
        return this.state.getClass().equals(UnparsedState.class);
    }

    void addValue(String value) {
        this.state = this.state.addValue(value);
    }

    void addOption(String option) throws ArgumentValidationException {
        this.state = this.state.addOption(option);
    }

    ArgumentCollection getParsedArguments() {
        return new ArgumentCollectionImpl(new LinkedHashMap<String, List<String>>(this.arguments), new ArrayList<String>(this.unparsed));
    }

    private ArgumentValidationException misplacedOption(final String option) {
        return new ArgumentValidationException(new ArgumentValidationException.ValidationError(){

            @Override
            public ArgumentValidationException.ValidationError.ErrorType getErrorType() {
                return ArgumentValidationException.ValidationError.ErrorType.MisplacedOption;
            }

            @Override
            public String getMessage() {
                return option;
            }

            public String toString() {
                return String.format("Option not expected in this position: %s", this.getMessage());
            }
        });
    }

    private void addUnparsedValue(String value) {
        this.unparsed.add(value);
    }

    private void addFirstValueForOption(String option) {
        this.valuesForCurrentArgument = new ArrayList<String>();
        this.arguments.put(option, this.valuesForCurrentArgument);
    }

    private class OptionOrValue
    implements IParsingState {
        public OptionOrValue(String option) {
            ArgumentCollectionBuilder.this.addFirstValueForOption(option);
        }

        @Override
        public IParsingState addValue(String value) {
            ArgumentCollectionBuilder.this.valuesForCurrentArgument.add(value);
            return this;
        }

        @Override
        public IParsingState addOption(String option) {
            return new OptionOrValue(option);
        }
    }

    private class UnparsedState
    implements IParsingState {
        public UnparsedState() {
            ArgumentCollectionBuilder.this.valuesForCurrentArgument = null;
        }

        @Override
        public IParsingState addValue(String value) {
            ArgumentCollectionBuilder.this.addUnparsedValue(value);
            return this;
        }

        @Override
        public IParsingState addOption(String option) throws ArgumentValidationException {
            throw ArgumentCollectionBuilder.this.misplacedOption(option);
        }
    }

    private class NoOptions
    implements IParsingState {
        public NoOptions(String value) {
            ArgumentCollectionBuilder.this.addUnparsedValue(value);
        }

        @Override
        public IParsingState addValue(String value) {
            ArgumentCollectionBuilder.this.addUnparsedValue(value);
            return this;
        }

        @Override
        public IParsingState addOption(String option) throws ArgumentValidationException {
            throw ArgumentCollectionBuilder.this.misplacedOption(option);
        }
    }

    private class Initial
    implements IParsingState {
        private Initial() {
        }

        @Override
        public IParsingState addValue(String value) {
            return new NoOptions(value);
        }

        @Override
        public IParsingState addOption(String option) {
            return new OptionOrValue(option);
        }
    }

    private static interface IParsingState {
        public IParsingState addValue(String var1);

        public IParsingState addOption(String var1) throws ArgumentValidationException;
    }
}

