/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public abstract class AbstractComplexMatrix
extends Matrix {
    protected AbstractComplexMatrix(int n, int n2) {
        super(n, n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractComplexMatrix) {
            return this.equals((AbstractComplexMatrix)object);
        }
        return false;
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix != null && this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (this.getElement(n, n2).subtract(abstractComplexMatrix.getElement(n, n2)).norm() > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractDoubleMatrix real() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2).real();
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix imag() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2).imag();
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public abstract Complex getElement(int var1, int var2);

    public abstract double getRealElement(int var1, int var2);

    public abstract double getImagElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, Complex var3);

    public abstract void setElement(int var1, int var2, double var3, double var5);

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.numCols) {
                d2 += this.getElement(n, n2).norm();
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d += this.getRealElement(n, n2) * this.getRealElement(n, n2) + this.getImagElement(n, n2) * this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.getRealElement(n, 0);
            dArray2[n][0] = -this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.getRealElement(n, n2);
                dArray2[n][n2] = -this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexMatrix) {
            return this.add((AbstractComplexMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix add(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getRealElement(n, 0) + abstractComplexMatrix.getRealElement(n, 0);
                dArray2[n][0] = this.getImagElement(n, 0) + abstractComplexMatrix.getImagElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getRealElement(n, n2) + abstractComplexMatrix.getRealElement(n, n2);
                    dArray2[n][n2] = this.getImagElement(n, n2) + abstractComplexMatrix.getImagElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexMatrix) {
            return this.subtract((AbstractComplexMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix subtract(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getRealElement(n, 0) - abstractComplexMatrix.getRealElement(n, 0);
                dArray2[n][0] = this.getImagElement(n, 0) - abstractComplexMatrix.getImagElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getRealElement(n, n2) - abstractComplexMatrix.getRealElement(n, n2);
                    dArray2[n][n2] = this.getImagElement(n, n2) - abstractComplexMatrix.getImagElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.getRealElement(n, 0) - d2 * this.getImagElement(n, 0);
            dArray2[n][0] = d2 * this.getRealElement(n, 0) + d * this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.getRealElement(n, n2) - d2 * this.getImagElement(n, n2);
                dArray2[n][n2] = d2 * this.getRealElement(n, n2) + d * this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.getRealElement(n, 0);
            dArray2[n][0] = d * this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.getRealElement(n, n2);
                dArray2[n][n2] = d * this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public final VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexMatrix scalarDivide(Complex complex) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = this.getElement(n, 0).divide(complex);
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = this.getElement(n, n2).divide(complex);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public AbstractComplexMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.getRealElement(n, 0) / d;
            dArray2[n][0] = this.getImagElement(n, 0) / d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getRealElement(n, n2) / d;
                dArray2[n][n2] = this.getImagElement(n, n2) / d;
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public Complex scalarProduct(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double d = 0.0;
            double d2 = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.getRealElement(n, 0) * abstractComplexMatrix.getRealElement(n, 0) + this.getImagElement(n, 0) * abstractComplexMatrix.getImagElement(n, 0);
                d2 += this.getImagElement(n, 0) * abstractComplexMatrix.getRealElement(n, 0) - this.getRealElement(n, 0) * abstractComplexMatrix.getImagElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.getRealElement(n, n2) * abstractComplexMatrix.getRealElement(n, n2) + this.getImagElement(n, n2) * abstractComplexMatrix.getImagElement(n, n2);
                    d2 += this.getImagElement(n, n2) * abstractComplexMatrix.getRealElement(n, n2) - this.getRealElement(n, n2) * abstractComplexMatrix.getImagElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new Complex(d, d2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexVector multiply(AbstractComplexVector abstractComplexVector) {
        if (this.numCols == abstractComplexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = this.getElement(n, 0).multiply(abstractComplexVector.getComponent(0));
                dArray[n] = complex.real();
                dArray2[n] = complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = this.getElement(n, n2).multiply(abstractComplexVector.getComponent(n2));
                    int n3 = n;
                    dArray[n3] = dArray[n3] + complex.real();
                    int n4 = n;
                    dArray2[n4] = dArray2[n4] + complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof AbstractComplexMatrix) {
            return this.multiply((AbstractComplexMatrix)member);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public AbstractComplexMatrix multiply(AbstractComplexMatrix abstractComplexMatrix) {
        if (this.numCols == abstractComplexMatrix.rows()) {
            double[][] dArray = new double[this.numRows][abstractComplexMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][abstractComplexMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < abstractComplexMatrix.columns()) {
                    Complex complex = this.getElement(n, 0).multiply(abstractComplexMatrix.getElement(0, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        complex = this.getElement(n, n3).multiply(abstractComplexMatrix.getElement(n3, n2));
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + complex.real();
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + complex.imag();
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == abstractComplexMatrix.columns()) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix directSum(AbstractComplexMatrix abstractComplexMatrix) {
        double[][] dArray = new double[this.numRows + abstractComplexMatrix.numRows][this.numCols + abstractComplexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows + abstractComplexMatrix.numRows][this.numCols + abstractComplexMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getRealElement(n, n2);
                dArray2[n][n2] = this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < abstractComplexMatrix.numRows) {
            int n4 = 0;
            while (n4 < abstractComplexMatrix.numCols) {
                dArray[n3 + this.numRows][n4 + this.numCols] = abstractComplexMatrix.getRealElement(n3, n4);
                dArray2[n3 + this.numRows][n4 + this.numCols] = abstractComplexMatrix.getImagElement(n3, n4);
                ++n4;
            }
            ++n3;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix tensor(AbstractComplexMatrix abstractComplexMatrix) {
        double[][] dArray = new double[this.numRows * abstractComplexMatrix.numRows][this.numCols * abstractComplexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows * abstractComplexMatrix.numRows][this.numCols * abstractComplexMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < abstractComplexMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < abstractComplexMatrix.numCols) {
                        Complex complex = this.getElement(n, n2).multiply(abstractComplexMatrix.getElement(n3, n4));
                        dArray[n * abstractComplexMatrix.numRows + n3][n2 * abstractComplexMatrix.numCols + n4] = complex.real();
                        dArray2[n * abstractComplexMatrix.numRows + n3][n2 * abstractComplexMatrix.numCols + n4] = complex.imag();
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.getRealElement(n, 0);
            dArray2[0][n] = -this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.getRealElement(n, n2);
                dArray2[n2][n] = -this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix conjugate() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.getRealElement(n, 0);
            dArray2[n][0] = -this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getRealElement(n, n2);
                dArray2[n][n2] = -this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.getRealElement(n, 0);
            dArray2[0][n] = this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.getRealElement(n, n2);
                dArray2[n2][n] = this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = complexMapping.map(this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = complexMapping.map(this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }
}

