/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.LinearMath;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.SquareMatrix;
import JSci.maths.algebras.CStarAlgebra;
import JSci.maths.groups.AbelianGroup;

public abstract class AbstractComplexSquareMatrix
extends AbstractComplexMatrix
implements CStarAlgebra.Member,
SquareMatrix {
    protected transient AbstractComplexSquareMatrix[] LU;
    protected transient int[] LUpivot;

    protected AbstractComplexSquareMatrix(int n) {
        super(n, n);
    }

    public AbstractDoubleMatrix real() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2).real();
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public AbstractDoubleMatrix imag() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2).imag();
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public boolean isHermitian() {
        return this.equals(this.hermitianAdjoint());
    }

    public boolean isUnitary() {
        return this.multiply(this.hermitianAdjoint()).equals(ComplexDiagonalMatrix.identity(this.numRows));
    }

    public Complex det() {
        if (this.numRows == 2) {
            return new Complex(this.getRealElement(0, 0) * this.getRealElement(1, 1) - this.getImagElement(0, 0) * this.getImagElement(1, 1) - this.getRealElement(0, 1) * this.getRealElement(1, 0) + this.getImagElement(0, 1) * this.getImagElement(1, 0), this.getRealElement(0, 0) * this.getImagElement(1, 1) + this.getImagElement(0, 0) * this.getRealElement(1, 1) - this.getRealElement(0, 1) * this.getImagElement(1, 0) - this.getImagElement(0, 1) * this.getRealElement(1, 0));
        }
        AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray = this.luDecompose(null);
        double d = abstractComplexSquareMatrixArray[1].getRealElement(0, 0);
        double d2 = abstractComplexSquareMatrixArray[1].getImagElement(0, 0);
        int n = 1;
        while (n < this.numRows) {
            double d3 = d * abstractComplexSquareMatrixArray[1].getRealElement(n, n) - d2 * abstractComplexSquareMatrixArray[1].getImagElement(n, n);
            d2 = d * abstractComplexSquareMatrixArray[1].getImagElement(n, n) + d2 * abstractComplexSquareMatrixArray[1].getRealElement(n, n);
            d = d3;
            ++n;
        }
        return new Complex(d * (double)this.LUpivot[this.numRows], d2 * (double)this.LUpivot[this.numRows]);
    }

    public Complex trace() {
        double d = this.getRealElement(0, 0);
        double d2 = this.getImagElement(0, 0);
        int n = 1;
        while (n < this.numRows) {
            d += this.getRealElement(n, n);
            d2 += this.getImagElement(n, n);
            ++n;
        }
        return new Complex(d, d2);
    }

    public double norm() {
        try {
            return this.operatorNorm();
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            throw new RuntimeException(maximumIterationsExceededException);
        }
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((AbstractComplexSquareMatrix)this.hermitianAdjoint().multiply(this))));
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.getRealElement(n, 0);
            dArray2[n][0] = -this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.getRealElement(n, n2);
                dArray2[n][n2] = -this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public final AbstractComplexMatrix add(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof AbstractComplexSquareMatrix) {
            return this.add((AbstractComplexSquareMatrix)abstractComplexMatrix);
        }
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            return this.add(new SquareMatrixAdaptor(abstractComplexMatrix));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getRealElement(n, 0) + abstractComplexSquareMatrix.getRealElement(n, 0);
                dArray2[n][0] = this.getImagElement(n, 0) + abstractComplexSquareMatrix.getImagElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getRealElement(n, n2) + abstractComplexSquareMatrix.getRealElement(n, n2);
                    dArray2[n][n2] = this.getImagElement(n, n2) + abstractComplexSquareMatrix.getImagElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbstractComplexMatrix subtract(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof AbstractComplexSquareMatrix) {
            return this.subtract((AbstractComplexSquareMatrix)abstractComplexMatrix);
        }
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            return this.subtract(new SquareMatrixAdaptor(abstractComplexMatrix));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getRealElement(n, 0) - abstractComplexSquareMatrix.getRealElement(n, 0);
                dArray2[n][0] = this.getImagElement(n, 0) - abstractComplexSquareMatrix.getImagElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getRealElement(n, n2) - abstractComplexSquareMatrix.getRealElement(n, n2);
                    dArray2[n][n2] = this.getImagElement(n, n2) - abstractComplexSquareMatrix.getImagElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.getRealElement(n, 0) - d2 * this.getImagElement(n, 0);
            dArray2[n][0] = d2 * this.getRealElement(n, 0) + d * this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.getRealElement(n, n2) - d2 * this.getImagElement(n, n2);
                dArray2[n][n2] = d2 * this.getRealElement(n, n2) + d * this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.getRealElement(n, 0);
            dArray2[n][0] = d * this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.getRealElement(n, n2);
                dArray2[n][n2] = d * this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarDivide(Complex complex) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = this.getElement(n, 0).divide(complex);
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = this.getElement(n, n2).divide(complex);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    public AbstractComplexMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.getRealElement(n, 0) / d;
            dArray2[n][0] = this.getImagElement(n, 0) / d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getRealElement(n, n2) / d;
                dArray2[n][n2] = this.getImagElement(n, n2) / d;
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public final Complex scalarProduct(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof AbstractComplexSquareMatrix) {
            return this.scalarProduct((AbstractComplexSquareMatrix)abstractComplexMatrix);
        }
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            return this.scalarProduct(new SquareMatrixAdaptor(abstractComplexMatrix));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Complex scalarProduct(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double d = 0.0;
            double d2 = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.getRealElement(n, 0) * abstractComplexSquareMatrix.getRealElement(n, 0) + this.getImagElement(n, 0) * abstractComplexSquareMatrix.getImagElement(n, 0);
                d2 += this.getImagElement(n, 0) * abstractComplexSquareMatrix.getRealElement(n, 0) - this.getRealElement(n, 0) * abstractComplexSquareMatrix.getImagElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.getRealElement(n, n2) * abstractComplexSquareMatrix.getRealElement(n, n2) + this.getImagElement(n, n2) * abstractComplexSquareMatrix.getImagElement(n, n2);
                    d2 += this.getImagElement(n, n2) * abstractComplexSquareMatrix.getRealElement(n, n2) - this.getRealElement(n, n2) * abstractComplexSquareMatrix.getImagElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new Complex(d, d2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < abstractComplexSquareMatrix.columns()) {
                    Complex complex = this.getElement(n, 0).multiply(abstractComplexSquareMatrix.getElement(0, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        complex = this.getElement(n, n3).multiply(abstractComplexSquareMatrix.getElement(n3, n2));
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + complex.real();
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + complex.imag();
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexSquareMatrix directSum(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        double[][] dArray = new double[this.numRows + abstractComplexSquareMatrix.numRows][this.numCols + abstractComplexSquareMatrix.numCols];
        double[][] dArray2 = new double[this.numRows + abstractComplexSquareMatrix.numRows][this.numCols + abstractComplexSquareMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getRealElement(n, n2);
                dArray2[n][n2] = this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < abstractComplexSquareMatrix.numRows) {
            int n4 = 0;
            while (n4 < abstractComplexSquareMatrix.numCols) {
                dArray[n3 + this.numRows][n4 + this.numCols] = abstractComplexSquareMatrix.getRealElement(n3, n4);
                dArray2[n3 + this.numRows][n4 + this.numCols] = abstractComplexSquareMatrix.getImagElement(n3, n4);
                ++n4;
            }
            ++n3;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix tensor(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        double[][] dArray = new double[this.numRows * abstractComplexSquareMatrix.numRows][this.numCols * abstractComplexSquareMatrix.numCols];
        double[][] dArray2 = new double[this.numRows * abstractComplexSquareMatrix.numRows][this.numCols * abstractComplexSquareMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < abstractComplexSquareMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < abstractComplexSquareMatrix.numCols) {
                        Complex complex = this.getElement(n, n2).multiply(abstractComplexSquareMatrix.getElement(n3, n4));
                        dArray[n * abstractComplexSquareMatrix.numRows + n3][n2 * abstractComplexSquareMatrix.numCols + n4] = complex.real();
                        dArray2[n * abstractComplexSquareMatrix.numRows + n3][n2 * abstractComplexSquareMatrix.numCols + n4] = complex.imag();
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public final CStarAlgebra.Member involution() {
        return (CStarAlgebra.Member)((Object)this.hermitianAdjoint());
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.getRealElement(n, 0);
            dArray2[0][n] = -this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.getRealElement(n, n2);
                dArray2[n2][n] = -this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix conjugate() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.getRealElement(n, 0);
            dArray2[n][0] = -this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getRealElement(n, n2);
                dArray2[n][n2] = -this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.getRealElement(n, 0);
            dArray2[0][n] = this.getImagElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.getRealElement(n, n2);
                dArray2[n2][n] = this.getImagElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix inverse() {
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray = this.luDecompose(null);
        double d = abstractComplexSquareMatrixArray[0].getRealElement(0, 0) * abstractComplexSquareMatrixArray[0].getRealElement(0, 0) + abstractComplexSquareMatrixArray[0].getImagElement(0, 0) * abstractComplexSquareMatrixArray[0].getImagElement(0, 0);
        dArray[0][0] = abstractComplexSquareMatrixArray[0].getRealElement(0, 0) / d;
        dArray2[0][0] = -abstractComplexSquareMatrixArray[0].getImagElement(0, 0) / d;
        d = abstractComplexSquareMatrixArray[1].getRealElement(0, 0) * abstractComplexSquareMatrixArray[1].getRealElement(0, 0) + abstractComplexSquareMatrixArray[1].getImagElement(0, 0) * abstractComplexSquareMatrixArray[1].getImagElement(0, 0);
        dArray3[0][0] = abstractComplexSquareMatrixArray[1].getRealElement(0, 0) / d;
        dArray4[0][0] = -abstractComplexSquareMatrixArray[1].getImagElement(0, 0) / d;
        int n2 = 1;
        while (n2 < n) {
            d = abstractComplexSquareMatrixArray[0].getRealElement(n2, n2) * abstractComplexSquareMatrixArray[0].getRealElement(n2, n2) + abstractComplexSquareMatrixArray[0].getImagElement(n2, n2) * abstractComplexSquareMatrixArray[0].getImagElement(n2, n2);
            dArray[n2][n2] = abstractComplexSquareMatrixArray[0].getRealElement(n2, n2) / d;
            dArray2[n2][n2] = -abstractComplexSquareMatrixArray[0].getImagElement(n2, n2) / d;
            d = abstractComplexSquareMatrixArray[1].getRealElement(n2, n2) * abstractComplexSquareMatrixArray[1].getRealElement(n2, n2) + abstractComplexSquareMatrixArray[1].getImagElement(n2, n2) * abstractComplexSquareMatrixArray[1].getImagElement(n2, n2);
            dArray3[n2][n2] = abstractComplexSquareMatrixArray[1].getRealElement(n2, n2) / d;
            dArray4[n2][n2] = -abstractComplexSquareMatrixArray[1].getImagElement(n2, n2) / d;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = n3 + 1;
            while (n4 < n) {
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                int n5 = n3;
                while (n5 < n4) {
                    d2 -= abstractComplexSquareMatrixArray[0].getRealElement(n4, n5) * dArray[n5][n3] - abstractComplexSquareMatrixArray[0].getImagElement(n4, n5) * dArray2[n5][n3];
                    d3 -= abstractComplexSquareMatrixArray[0].getImagElement(n4, n5) * dArray[n5][n3] + abstractComplexSquareMatrixArray[0].getRealElement(n4, n5) * dArray2[n5][n3];
                    d4 -= dArray3[n3][n5] * abstractComplexSquareMatrixArray[1].getRealElement(n5, n4) - dArray4[n3][n5] * abstractComplexSquareMatrixArray[1].getImagElement(n5, n4);
                    d5 -= dArray4[n3][n5] * abstractComplexSquareMatrixArray[1].getRealElement(n5, n4) + dArray3[n3][n5] * abstractComplexSquareMatrixArray[1].getImagElement(n5, n4);
                    ++n5;
                }
                d = abstractComplexSquareMatrixArray[0].getRealElement(n4, n4) * abstractComplexSquareMatrixArray[0].getRealElement(n4, n4) + abstractComplexSquareMatrixArray[0].getImagElement(n4, n4) * abstractComplexSquareMatrixArray[0].getImagElement(n4, n4);
                dArray[n4][n3] = (d2 * abstractComplexSquareMatrixArray[0].getRealElement(n4, n4) + d3 * abstractComplexSquareMatrixArray[0].getImagElement(n4, n4)) / d;
                dArray2[n4][n3] = (d3 * abstractComplexSquareMatrixArray[0].getRealElement(n4, n4) - d2 * abstractComplexSquareMatrixArray[0].getImagElement(n4, n4)) / d;
                d = abstractComplexSquareMatrixArray[1].getRealElement(n4, n4) * abstractComplexSquareMatrixArray[1].getRealElement(n4, n4) + abstractComplexSquareMatrixArray[1].getImagElement(n4, n4) * abstractComplexSquareMatrixArray[1].getImagElement(n4, n4);
                dArray3[n3][n4] = (d4 * abstractComplexSquareMatrixArray[1].getRealElement(n4, n4) + d5 * abstractComplexSquareMatrixArray[1].getImagElement(n4, n4)) / d;
                dArray4[n3][n4] = (d5 * abstractComplexSquareMatrixArray[1].getRealElement(n4, n4) - d4 * abstractComplexSquareMatrixArray[1].getImagElement(n4, n4)) / d;
                ++n4;
            }
            ++n3;
        }
        double[][] dArray5 = new double[n][n];
        double[][] dArray6 = new double[n][n];
        int n6 = 0;
        while (n6 < n) {
            int n7;
            int n8 = 0;
            while (n8 < n6) {
                n7 = n6;
                while (n7 < n) {
                    double[] dArray7 = dArray5[n6];
                    int n9 = this.LUpivot[n8];
                    dArray7[n9] = dArray7[n9] + (dArray3[n6][n7] * dArray[n7][n8] - dArray4[n6][n7] * dArray2[n7][n8]);
                    double[] dArray8 = dArray6[n6];
                    int n10 = this.LUpivot[n8];
                    dArray8[n10] = dArray8[n10] + (dArray4[n6][n7] * dArray[n7][n8] + dArray3[n6][n7] * dArray2[n7][n8]);
                    ++n7;
                }
                ++n8;
            }
            n7 = n6;
            while (n7 < n) {
                int n11 = n7;
                while (n11 < n) {
                    double[] dArray9 = dArray5[n6];
                    int n12 = this.LUpivot[n7];
                    dArray9[n12] = dArray9[n12] + (dArray3[n6][n11] * dArray[n11][n7] - dArray4[n6][n11] * dArray2[n11][n7]);
                    double[] dArray10 = dArray6[n6];
                    int n13 = this.LUpivot[n7];
                    dArray10[n13] = dArray10[n13] + (dArray4[n6][n11] * dArray[n11][n7] + dArray3[n6][n11] * dArray2[n11][n7]);
                    ++n11;
                }
                ++n7;
            }
            ++n6;
        }
        return new ComplexSquareMatrix(dArray5, dArray6);
    }

    public AbstractComplexSquareMatrix[] luDecompose(int[] nArray) {
        int n;
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        double[][] dArray4 = new double[n2][n2];
        double[] dArray5 = new double[n2];
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        nArray[n2] = 1;
        int n4 = 0;
        while (n4 < n2) {
            double d;
            int n5;
            double d2;
            double d3;
            double d4;
            double d5;
            n = 0;
            while (n < n4) {
                d5 = this.getRealElement(nArray[n], n4);
                double d6 = this.getImagElement(nArray[n], n4);
                int n6 = 0;
                while (n6 < n) {
                    d5 -= dArray3[n][n6] * dArray3[n6][n4] - dArray4[n][n6] * dArray4[n6][n4];
                    d6 -= dArray4[n][n6] * dArray3[n6][n4] + dArray3[n][n6] * dArray4[n6][n4];
                    ++n6;
                }
                dArray3[n][n4] = d5;
                dArray4[n][n4] = d6;
                ++n;
            }
            d5 = 0.0;
            int n7 = n4;
            int n8 = n4;
            while (n8 < n2) {
                double d7 = this.getRealElement(nArray[n8], n4);
                d4 = this.getImagElement(nArray[n8], n4);
                int n9 = 0;
                while (n9 < n4) {
                    d7 -= dArray3[n8][n9] * dArray3[n9][n4] - dArray4[n8][n9] * dArray4[n9][n4];
                    d4 -= dArray4[n8][n9] * dArray3[n9][n4] + dArray3[n8][n9] * dArray4[n9][n4];
                    ++n9;
                }
                dArray3[n8][n4] = d7;
                dArray4[n8][n4] = d4;
                double d8 = d7 * d7 + d4 * d4;
                if (d8 > d5) {
                    d5 = d8;
                    n7 = n8;
                }
                ++n8;
            }
            if (n7 != n4) {
                System.arraycopy(dArray3[n4], 0, dArray5, 0, n4 + 1);
                System.arraycopy(dArray3[n7], 0, dArray3[n4], 0, n4 + 1);
                System.arraycopy(dArray5, 0, dArray3[n7], 0, n4 + 1);
                System.arraycopy(dArray4[n4], 0, dArray5, 0, n4 + 1);
                System.arraycopy(dArray4[n7], 0, dArray4[n4], 0, n4 + 1);
                System.arraycopy(dArray5, 0, dArray4[n7], 0, n4 + 1);
                int n10 = nArray[n4];
                nArray[n4] = nArray[n7];
                nArray[n7] = n10;
                nArray[n2] = -nArray[n2];
            }
            double d9 = dArray3[n4][n4];
            d4 = dArray4[n4][n4];
            if (Math.abs(d9) < Math.abs(d4)) {
                d3 = d9 / d4;
                d2 = d9 * d3 + d4;
                n5 = n4 + 1;
                while (n5 < n2) {
                    d = (dArray3[n5][n4] * d3 + dArray4[n5][n4]) / d2;
                    dArray4[n5][n4] = (dArray4[n5][n4] * d3 - dArray3[n5][n4]) / d2;
                    dArray3[n5][n4] = d;
                    ++n5;
                }
            } else {
                d3 = d4 / d9;
                d2 = d9 + d4 * d3;
                n5 = n4 + 1;
                while (n5 < n2) {
                    d = (dArray3[n5][n4] + dArray4[n5][n4] * d3) / d2;
                    dArray4[n5][n4] = (dArray4[n5][n4] - dArray3[n5][n4] * d3) / d2;
                    dArray3[n5][n4] = d;
                    ++n5;
                }
            }
            ++n4;
        }
        n = 0;
        while (n < n2) {
            dArray[n][n] = 1.0;
            int n11 = n + 1;
            while (n11 < n2) {
                dArray[n11][n] = dArray3[n11][n];
                dArray2[n11][n] = dArray4[n11][n];
                dArray3[n11][n] = 0.0;
                dArray4[n11][n] = 0.0;
                ++n11;
            }
            ++n;
        }
        this.LU = new AbstractComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(dArray, dArray2);
        this.LU[1] = new ComplexSquareMatrix(dArray3, dArray4);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractComplexSquareMatrix[] polarDecompose() {
        Complex complex;
        double[] dArray;
        int n = this.numRows;
        AbstractComplexVector[] abstractComplexVectorArray = new AbstractComplexVector[n];
        try {
            dArray = LinearMath.eigenSolveHermitian(this, abstractComplexVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            double d = Math.abs(dArray[n2]);
            complex = abstractComplexVectorArray[n2].getComponent(0).conjugate();
            dArray2[n2][0] = dArray[n2] * complex.real() / d;
            dArray3[n2][0] = dArray[n2] * complex.imag() / d;
            dArray4[n2][0] = d * complex.real();
            dArray5[n2][0] = d * complex.imag();
            int n3 = 1;
            while (n3 < n) {
                complex = abstractComplexVectorArray[n2].getComponent(n3).conjugate();
                dArray2[n2][n3] = dArray[n2] * complex.real() / d;
                dArray3[n2][n3] = dArray[n2] * complex.imag() / d;
                dArray4[n2][n3] = d * complex.real();
                dArray5[n2][n3] = d * complex.imag();
                ++n3;
            }
            ++n2;
        }
        double[][] dArray6 = new double[n][n];
        double[][] dArray7 = new double[n][n];
        double[][] dArray8 = new double[n][n];
        double[][] dArray9 = new double[n][n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                complex = abstractComplexVectorArray[0].getComponent(n4);
                dArray6[n4][n5] = dArray2[0][n5] * complex.real() - dArray3[0][n5] * complex.imag();
                dArray7[n4][n5] = dArray3[0][n5] * complex.real() + dArray2[0][n5] * complex.imag();
                dArray8[n4][n5] = dArray4[0][n5] * complex.real() - dArray5[0][n5] * complex.imag();
                dArray9[n4][n5] = dArray5[0][n5] * complex.real() + dArray4[0][n5] * complex.imag();
                int n6 = 1;
                while (n6 < n) {
                    complex = abstractComplexVectorArray[n6].getComponent(n4);
                    double[] dArray10 = dArray6[n4];
                    int n7 = n5;
                    dArray10[n7] = dArray10[n7] + (dArray2[n6][n5] * complex.real() - dArray3[n6][n5] * complex.imag());
                    double[] dArray11 = dArray7[n4];
                    int n8 = n5;
                    dArray11[n8] = dArray11[n8] + (dArray3[n6][n5] * complex.real() + dArray2[n6][n5] * complex.imag());
                    double[] dArray12 = dArray8[n4];
                    int n9 = n5;
                    dArray12[n9] = dArray12[n9] + (dArray4[n6][n5] * complex.real() - dArray5[n6][n5] * complex.imag());
                    double[] dArray13 = dArray9[n4];
                    int n10 = n5;
                    dArray13[n10] = dArray13[n10] + (dArray5[n6][n5] * complex.real() + dArray4[n6][n5] * complex.imag());
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(dArray6, dArray7), new ComplexSquareMatrix(dArray8, dArray9)};
        return abstractComplexSquareMatrixArray;
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = complexMapping.map(this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = complexMapping.map(this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    private static class SquareMatrixAdaptor
    extends AbstractComplexSquareMatrix {
        private final AbstractComplexMatrix matrix;

        private SquareMatrixAdaptor(AbstractComplexMatrix abstractComplexMatrix) {
            super(abstractComplexMatrix.rows());
            this.matrix = abstractComplexMatrix;
        }

        public Complex getElement(int n, int n2) {
            return this.matrix.getElement(n, n2);
        }

        public double getRealElement(int n, int n2) {
            return this.matrix.getRealElement(n, n2);
        }

        public double getImagElement(int n, int n2) {
            return this.matrix.getImagElement(n, n2);
        }

        public void setElement(int n, int n2, Complex complex) {
            this.matrix.setElement(n, n2, complex);
        }

        public void setElement(int n, int n2, double d, double d2) {
            this.matrix.setElement(n, n2, d, d2);
        }
    }
}

