/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public abstract class AbstractDoubleMatrix
extends Matrix {
    protected AbstractDoubleMatrix(int n, int n2) {
        super(n, n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractDoubleMatrix) {
            return this.equals((AbstractDoubleMatrix)object);
        }
        return false;
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix != null && this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (Math.abs(this.getElement(n, n2) - abstractDoubleMatrix.getElement(n, n2)) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                nArray[n][n2] = Math.round((float)this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.numRows, this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                complexMatrix.setElement(n, n2, this.getElement(n, n2), 0.0);
                ++n2;
            }
            ++n;
        }
        return complexMatrix;
    }

    public abstract double getElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, double var3);

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.numCols) {
                d2 += Math.abs(this.getElement(n, n2));
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d = ExtraMath.hypot(d, this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.getElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleMatrix) {
            return this.add((AbstractDoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix add(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) + abstractDoubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) + abstractDoubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleMatrix) {
            return this.subtract((AbstractDoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - abstractDoubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - abstractDoubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Number) {
            return this.scalarMultiply(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.getElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public final VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Number) {
            return this.scalarDivide(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.getElement(n, 0) / d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2) / d;
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public double scalarProduct(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.getElement(n, 0) * abstractDoubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.getElement(n, n2) * abstractDoubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                dArray[n] = this.getElement(n, 0) * abstractDoubleVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.getElement(n, n2) * abstractDoubleVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof AbstractDoubleMatrix) {
            return this.multiply((AbstractDoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numCols == abstractDoubleMatrix.rows()) {
            int n = abstractDoubleMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            int n2 = 0;
            while (n2 < this.numRows) {
                int n3 = 0;
                while (n3 < n) {
                    dArray[n2][n3] = this.getElement(n2, 0) * abstractDoubleMatrix.getElement(0, n3);
                    int n4 = 1;
                    while (n4 < this.numCols) {
                        double[] dArray2 = dArray[n2];
                        int n5 = n3;
                        dArray2[n5] = dArray2[n5] + this.getElement(n2, n4) * abstractDoubleMatrix.getElement(n4, n3);
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (this.numRows == n) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix directSum(AbstractDoubleMatrix abstractDoubleMatrix) {
        int n;
        double[][] dArray = new double[this.numRows + abstractDoubleMatrix.numRows][this.numCols + abstractDoubleMatrix.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                dArray[n2][n] = this.getElement(n2, n);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < abstractDoubleMatrix.numRows) {
            int n3 = 0;
            while (n3 < abstractDoubleMatrix.numCols) {
                dArray[n + this.numRows][n3 + this.numCols] = abstractDoubleMatrix.getElement(n, n3);
                ++n3;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix tensor(AbstractDoubleMatrix abstractDoubleMatrix) {
        double[][] dArray = new double[this.numRows * abstractDoubleMatrix.numRows][this.numCols * abstractDoubleMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < abstractDoubleMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < abstractDoubleMatrix.numCols) {
                        dArray[n * abstractDoubleMatrix.numRows + n3][n2 * abstractDoubleMatrix.numCols + n4] = this.getElement(n, n2) * abstractDoubleMatrix.getElement(n3, n4);
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.getElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = mapping.map(this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = mapping.map(this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }
}

