/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.AbstractIntegerVector;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public abstract class AbstractIntegerMatrix
extends Matrix {
    protected AbstractIntegerMatrix(int n, int n2) {
        super(n, n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AbstractIntegerMatrix) {
            return this.equals((AbstractIntegerMatrix)object);
        }
        return false;
    }

    public boolean equals(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (abstractIntegerMatrix != null && this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if ((double)Math.abs(this.getElement(n, n2) - abstractIntegerMatrix.getElement(n, n2)) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractDoubleMatrix toDoubleMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.numRows, this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                complexMatrix.setElement(n, n2, this.getElement(n, n2), 0.0);
                ++n2;
            }
            ++n;
        }
        return complexMatrix;
    }

    public abstract int getElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, int var3);

    public int infNorm() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.numCols) {
                n3 += Math.abs(this.getElement(n2, n4));
                ++n4;
            }
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d = ExtraMath.hypot(d, this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            nArray[n][0] = -this.getElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                nArray[n][n2] = -this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public final AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractIntegerMatrix) {
            return this.add((AbstractIntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix add(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.getElement(n, 0) + abstractIntegerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, n2) + abstractIntegerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractIntegerMatrix) {
            return this.subtract((AbstractIntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix subtract(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.getElement(n, 0) - abstractIntegerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.getElement(n, n2) - abstractIntegerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public final Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Number) {
            return this.scalarMultiply(((Number)((Object)member)).intValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix scalarMultiply(int n) {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            nArray[n2][0] = n * this.getElement(n2, 0);
            int n3 = 1;
            while (n3 < this.numCols) {
                nArray[n2][n3] = n * this.getElement(n2, n3);
                ++n3;
            }
            ++n2;
        }
        return new IntegerMatrix(nArray);
    }

    public final VectorSpace.Member scalarDivide(Field.Member member) {
        throw new UnsupportedOperationException("Not an algebra");
    }

    public int scalarProduct(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.numRows) {
                n += this.getElement(n2, 0) * abstractIntegerMatrix.getElement(n2, 0);
                int n3 = 1;
                while (n3 < this.numCols) {
                    n += this.getElement(n2, n3) * abstractIntegerMatrix.getElement(n2, n3);
                    ++n3;
                }
                ++n2;
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerVector multiply(AbstractIntegerVector abstractIntegerVector) {
        if (this.numCols == abstractIntegerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                nArray[n] = this.getElement(n, 0) * abstractIntegerVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + this.getElement(n, n2) * abstractIntegerVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public final Ring.Member multiply(Ring.Member member) {
        if (member instanceof AbstractIntegerMatrix) {
            return this.multiply((AbstractIntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix multiply(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numCols == abstractIntegerMatrix.rows()) {
            int n = abstractIntegerMatrix.columns();
            int[][] nArray = new int[this.numRows][n];
            int n2 = 0;
            while (n2 < this.numRows) {
                int n3 = 0;
                while (n3 < n) {
                    nArray[n2][n3] = this.getElement(n2, 0) * abstractIntegerMatrix.getElement(0, n3);
                    int n4 = 1;
                    while (n4 < this.numCols) {
                        int[] nArray2 = nArray[n2];
                        int n5 = n3;
                        nArray2[n5] = nArray2[n5] + this.getElement(n2, n4) * abstractIntegerMatrix.getElement(n4, n3);
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (this.numRows == n) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractIntegerMatrix directSum(AbstractIntegerMatrix abstractIntegerMatrix) {
        int n;
        int[][] nArray = new int[this.numRows + abstractIntegerMatrix.numRows][this.numCols + abstractIntegerMatrix.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                nArray[n2][n] = this.getElement(n2, n);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < abstractIntegerMatrix.numRows) {
            int n3 = 0;
            while (n3 < abstractIntegerMatrix.numCols) {
                nArray[n + this.numRows][n3 + this.numCols] = abstractIntegerMatrix.getElement(n, n3);
                ++n3;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractIntegerMatrix tensor(AbstractIntegerMatrix abstractIntegerMatrix) {
        int[][] nArray = new int[this.numRows * abstractIntegerMatrix.numRows][this.numCols * abstractIntegerMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < abstractIntegerMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < abstractIntegerMatrix.numCols) {
                        nArray[n * abstractIntegerMatrix.numRows + n3][n2 * abstractIntegerMatrix.numCols + n4] = this.getElement(n, n2) * abstractIntegerMatrix.getElement(n3, n4);
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public Matrix transpose() {
        int[][] nArray = new int[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            nArray[0][n] = this.getElement(n, 0);
            int n2 = 1;
            while (n2 < this.numCols) {
                nArray[n2][n] = this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }
}

