/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractComplexMatrix;
import JSci.maths.AbstractComplexSquareMatrix;
import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleMatrix;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.TridiagonalMatrix;

public class ComplexDiagonalMatrix
extends AbstractComplexSquareMatrix
implements DiagonalMatrix {
    protected final double[] diagRe;
    protected final double[] diagIm;

    public ComplexDiagonalMatrix(double[] dArray, double[] dArray2) {
        super(dArray.length);
        this.diagRe = dArray;
        this.diagIm = dArray2;
    }

    public ComplexDiagonalMatrix(int n) {
        this(new double[n], new double[n]);
    }

    public ComplexDiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        int n = 0;
        while (n < this.numRows) {
            if (complexArray[n].length != complexArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diagRe[n] = complexArray[n][n].real();
            this.diagIm[n] = complexArray[n][n].imag();
            ++n;
        }
    }

    public ComplexDiagonalMatrix(Complex[] complexArray) {
        this(complexArray.length);
        this.diagRe[0] = complexArray[0].real();
        this.diagIm[0] = complexArray[0].imag();
        int n = 1;
        while (n < complexArray.length) {
            this.diagRe[n] = complexArray[n].real();
            this.diagIm[n] = complexArray[n].imag();
            ++n;
        }
    }

    public static ComplexDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 1.0;
            ++n2;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof DiagonalMatrix) {
            if (this.numRows != abstractComplexMatrix.rows() || this.numCols != abstractComplexMatrix.columns()) {
                return false;
            }
            int n = 0;
            while (n < this.numRows) {
                if (!abstractComplexMatrix.getElement(n, n).equals(this.diagRe[n], this.diagIm[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return super.equals(abstractComplexMatrix);
    }

    public AbstractDoubleMatrix real() {
        return new DoubleDiagonalMatrix(this.diagRe);
    }

    public AbstractDoubleMatrix imag() {
        return new DoubleDiagonalMatrix(this.diagIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return new Complex(this.diagRe[n], this.diagIm[n]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getRealElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diagRe[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getImagElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diagIm[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diagRe[n] = complex.real();
        this.diagIm[n] = complex.imag();
    }

    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diagRe[n] = d;
        this.diagIm[n] = d2;
    }

    public Complex det() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            double d3 = d * this.diagRe[n] - d2 * this.diagIm[n];
            d2 = d2 * this.diagRe[n] + d * this.diagIm[n];
            d = d3;
            ++n;
        }
        return new Complex(d, d2);
    }

    public Complex trace() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diagRe[n];
            d2 += this.diagIm[n];
            ++n;
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            double d2 = this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n];
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public double frobeniusNorm() {
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public double operatorNorm() {
        return this.infNorm();
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.add((ComplexDiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = abstractComplexSquareMatrix.getElement(n, 0);
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = abstractComplexSquareMatrix.getElement(n, n2);
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(complexSquareMatrix.matrixRe[n], 0, dArray[n], 0, this.numCols);
                System.arraycopy(complexSquareMatrix.matrixIm[n], 0, dArray2[n], 0, this.numCols);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numRows) {
                double[] dArray3 = dArray[n2];
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + this.diagRe[n2];
                double[] dArray4 = dArray2[n2];
                int n4 = n2;
                dArray4[n4] = dArray4[n4] + this.diagIm[n2];
                ++n2;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (this.numRows == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(this.numRows);
            System.arraycopy(complexTridiagonalMatrix.ldiagRe, 0, complexTridiagonalMatrix2.ldiagRe, 0, complexTridiagonalMatrix.ldiagRe.length);
            System.arraycopy(complexTridiagonalMatrix.ldiagIm, 0, complexTridiagonalMatrix2.ldiagIm, 0, complexTridiagonalMatrix.ldiagIm.length);
            System.arraycopy(complexTridiagonalMatrix.udiagRe, 0, complexTridiagonalMatrix2.udiagRe, 0, complexTridiagonalMatrix.udiagRe.length);
            System.arraycopy(complexTridiagonalMatrix.udiagIm, 0, complexTridiagonalMatrix2.udiagIm, 0, complexTridiagonalMatrix.udiagIm.length);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] + complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] + complexTridiagonalMatrix.diagIm[0];
            int n = 1;
            while (n < this.numRows) {
                complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] + complexTridiagonalMatrix.diagRe[n];
                complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] + complexTridiagonalMatrix.diagIm[n];
                ++n;
            }
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix addTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] + complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] + complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = complex.real();
            complexTridiagonalMatrix.udiagIm[0] = complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = abstractComplexSquareMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix.ldiagRe[n2] = complex.real();
                complexTridiagonalMatrix.ldiagIm[n2] = complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2);
                complexTridiagonalMatrix.diagRe[n2] = this.diagRe[n2] + complex.real();
                complexTridiagonalMatrix.diagIm[n2] = this.diagIm[n2] + complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix.udiagRe[n2] = complex.real();
                complexTridiagonalMatrix.udiagIm[n2] = complex.imag();
                ++n2;
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] + complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] + complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix add(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.numRows == complexDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] + complexDiagonalMatrix.diagRe[0];
            dArray2[0] = this.diagIm[0] + complexDiagonalMatrix.diagIm[0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diagRe[n] + complexDiagonalMatrix.diagRe[n];
                dArray2[n] = this.diagIm[n] + complexDiagonalMatrix.diagIm[n];
                ++n;
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = abstractComplexSquareMatrix.getElement(n, 0);
                dArray[n][0] = -complex.real();
                dArray2[n][0] = -complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = abstractComplexSquareMatrix.getElement(n, n2);
                    dArray[n][n2] = -complex.real();
                    dArray2[n][n2] = -complex.imag();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = -complexSquareMatrix.matrixRe[n][0];
                dArray2[n][0] = -complexSquareMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = -complexSquareMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = -complexSquareMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] - complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] - complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = -complexTridiagonalMatrix.udiagRe[0];
            complexTridiagonalMatrix2.udiagIm[0] = -complexTridiagonalMatrix.udiagIm[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.ldiagRe[n2] = -complexTridiagonalMatrix.ldiagRe[n2];
                complexTridiagonalMatrix2.ldiagIm[n2] = -complexTridiagonalMatrix.ldiagIm[n2];
                complexTridiagonalMatrix2.diagRe[n2] = this.diagRe[n2] - complexTridiagonalMatrix.diagRe[n2];
                complexTridiagonalMatrix2.diagIm[n2] = this.diagIm[n2] - complexTridiagonalMatrix.diagIm[n2];
                complexTridiagonalMatrix2.udiagRe[n2] = -complexTridiagonalMatrix.udiagRe[n2];
                complexTridiagonalMatrix2.udiagIm[n2] = -complexTridiagonalMatrix.udiagIm[n2];
                ++n2;
            }
            complexTridiagonalMatrix2.ldiagRe[n] = -complexTridiagonalMatrix.ldiagRe[n];
            complexTridiagonalMatrix2.ldiagIm[n] = -complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] - complexTridiagonalMatrix.diagRe[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] - complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix subtractTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] - complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] - complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = -complex.real();
            complexTridiagonalMatrix.udiagIm[0] = -complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = abstractComplexSquareMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix.ldiagRe[n2] = -complex.real();
                complexTridiagonalMatrix.ldiagIm[n2] = -complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2);
                complexTridiagonalMatrix.diagRe[n2] = this.diagRe[n2] - complex.real();
                complexTridiagonalMatrix.diagIm[n2] = this.diagIm[n2] - complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix.udiagRe[n2] = -complex.real();
                complexTridiagonalMatrix.udiagIm[n2] = -complex.imag();
                ++n2;
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = -complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = -complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] - complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] - complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix subtract(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.numRows == complexDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] - complexDiagonalMatrix.diagRe[0];
            dArray2[0] = this.diagIm[0] - complexDiagonalMatrix.diagIm[0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diagRe[n] - complexDiagonalMatrix.diagRe[n];
                dArray2[n] = this.diagIm[n] - complexDiagonalMatrix.diagIm[n];
                ++n;
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        dArray[0] = d * this.diagRe[0] - d2 * this.diagIm[0];
        dArray2[0] = d2 * this.diagRe[0] + d * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = d * this.diagRe[n] - d2 * this.diagIm[n];
            dArray2[n] = d2 * this.diagRe[n] + d * this.diagIm[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        dArray[0] = d * this.diagRe[0];
        dArray2[0] = d * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = d * this.diagRe[n];
            dArray2[n] = d * this.diagIm[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public AbstractComplexVector multiply(AbstractComplexVector abstractComplexVector) {
        if (this.numCols == abstractComplexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            Complex complex = abstractComplexVector.getComponent(0);
            dArray[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            dArray2[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            int n = 1;
            while (n < this.numRows) {
                complex = abstractComplexVector.getComponent(n);
                dArray[n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                dArray2[n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = abstractComplexSquareMatrix.getElement(n, 0);
                dArray[n][0] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                dArray2[n][0] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                int n2 = 1;
                while (n2 < abstractComplexSquareMatrix.columns()) {
                    complex = abstractComplexSquareMatrix.getElement(n, n2);
                    dArray[n][n2] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                    dArray2[n][n2] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diagRe[n] * complexSquareMatrix.matrixRe[n][0] - this.diagIm[n] * complexSquareMatrix.matrixIm[n][0];
                dArray2[n][0] = this.diagIm[n] * complexSquareMatrix.matrixRe[n][0] + this.diagRe[n] * complexSquareMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.diagRe[n] * complexSquareMatrix.matrixRe[n][n2] - this.diagIm[n] * complexSquareMatrix.matrixIm[n][n2];
                    dArray2[n][n2] = this.diagIm[n] * complexSquareMatrix.matrixRe[n][n2] + this.diagRe[n] * complexSquareMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] * complexTridiagonalMatrix.diagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] * complexTridiagonalMatrix.diagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = this.diagRe[0] * complexTridiagonalMatrix.udiagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.udiagIm[0];
            complexTridiagonalMatrix2.udiagIm[0] = this.diagIm[0] * complexTridiagonalMatrix.udiagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.udiagIm[0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.ldiagRe[n2] = this.diagRe[n2] * complexTridiagonalMatrix.ldiagRe[n2] - this.diagIm[n2] * complexTridiagonalMatrix.ldiagIm[n2];
                complexTridiagonalMatrix2.ldiagIm[n2] = this.diagIm[n2] * complexTridiagonalMatrix.ldiagRe[n2] + this.diagRe[n2] * complexTridiagonalMatrix.ldiagIm[n2];
                complexTridiagonalMatrix2.diagRe[n2] = this.diagRe[n2] * complexTridiagonalMatrix.diagRe[n2] - this.diagIm[n2] * complexTridiagonalMatrix.diagIm[n2];
                complexTridiagonalMatrix2.diagIm[n2] = this.diagIm[n2] * complexTridiagonalMatrix.diagRe[n2] + this.diagRe[n2] * complexTridiagonalMatrix.diagIm[n2];
                complexTridiagonalMatrix2.udiagRe[n2] = this.diagRe[n2] * complexTridiagonalMatrix.udiagRe[n2] - this.diagIm[n2] * complexTridiagonalMatrix.udiagIm[n2];
                complexTridiagonalMatrix2.udiagIm[n2] = this.diagIm[n2] * complexTridiagonalMatrix.udiagRe[n2] + this.diagRe[n2] * complexTridiagonalMatrix.udiagIm[n2];
                ++n2;
            }
            complexTridiagonalMatrix2.ldiagRe[n] = this.diagRe[n] * complexTridiagonalMatrix.ldiagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.ldiagIm[n] = this.diagIm[n] * complexTridiagonalMatrix.ldiagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] * complexTridiagonalMatrix.diagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.diagIm[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] * complexTridiagonalMatrix.diagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix multiplyTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            complexTridiagonalMatrix.udiagIm[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = abstractComplexSquareMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix.ldiagRe[n2] = this.diagRe[n2] * complex.real() - this.diagIm[n2] * complex.imag();
                complexTridiagonalMatrix.ldiagIm[n2] = this.diagIm[n2] * complex.real() + this.diagRe[n2] * complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2);
                complexTridiagonalMatrix.diagRe[n2] = this.diagRe[n2] * complex.real() - this.diagIm[n2] * complex.imag();
                complexTridiagonalMatrix.diagIm[n2] = this.diagIm[n2] * complex.real() + this.diagRe[n2] * complex.imag();
                complex = abstractComplexSquareMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix.udiagRe[n2] = this.diagRe[n2] * complex.real() - this.diagIm[n2] * complex.imag();
                complexTridiagonalMatrix.udiagIm[n2] = this.diagIm[n2] * complex.real() + this.diagRe[n2] * complex.imag();
                ++n2;
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
            complexTridiagonalMatrix.ldiagIm[n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix multiply(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.numCols == complexDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] * complexDiagonalMatrix.diagRe[0] - this.diagIm[0] * complexDiagonalMatrix.diagIm[0];
            dArray2[0] = this.diagIm[0] * complexDiagonalMatrix.diagRe[0] + this.diagRe[0] * complexDiagonalMatrix.diagIm[0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diagRe[n] * complexDiagonalMatrix.diagRe[n] - this.diagIm[n] * complexDiagonalMatrix.diagIm[n];
                dArray2[n] = this.diagIm[n] * complexDiagonalMatrix.diagRe[n] + this.diagRe[n] * complexDiagonalMatrix.diagIm[n];
                ++n;
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        dArray[0] = this.diagRe[0] / d;
        dArray2[0] = -this.diagIm[0] / d;
        int n = 1;
        while (n < this.numRows) {
            d = this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n];
            dArray[n] = this.diagRe[n] / d;
            dArray2[n] = -this.diagIm[n] / d;
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        return this.conjugate();
    }

    public AbstractComplexMatrix conjugate() {
        double[] dArray = new double[this.numRows];
        dArray[0] = -this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = -this.diagIm[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(this.diagRe, dArray);
    }

    public Matrix transpose() {
        return this;
    }

    public AbstractComplexSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.numRows] = 1;
        this.LU = new AbstractComplexSquareMatrix[2];
        this.LU[0] = ComplexDiagonalMatrix.identity(this.numRows);
        this.LU[1] = this;
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[] complexArray = new Complex[this.numRows];
        complexArray[0] = complexMapping.map(this.diagRe[0], this.diagIm[0]);
        int n = 1;
        while (n < this.numRows) {
            complexArray[n] = complexMapping.map(this.diagRe[n], this.diagIm[n]);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }
}

